package com.mini.framework.third.aliyun.model.content;

import java.util.List;
import java.util.Optional;

import com.mini.framework.core.exception.BadReqGetNoDataException;
import com.mini.framework.third.aliyun.model.AbstractAliyunResponse;
import com.mini.framework.third.aliyun.model.content.text.TextTask;
import com.mini.framework.third.aliyun.model.content.type.Suggestion;
import com.mini.framework.util.function.PredicateSpread;

/**
 * 内容绿化
 * https://help.aliyun.com/document_detail/70439.html?spm=a2c4g.11174283.6.664
 * .7a1174879B6ARd
 * 
 * @author jayheo
 *
 */
public class ContentGreenTextResponse extends AbstractAliyunResponse {

	private List<TextTask> data;

	public List<TextTask> getData() {
		return data;
	}

	public void setData(List<TextTask> data) {
		this.data = data;
	}
	
	
	public String mapperDataId(String content){
		return data.stream().filter(PredicateSpread.isEqual(TextTask::getContent, content))
				.findFirst().map(TextTask::getDataId)
				.orElseThrow(()->new BadReqGetNoDataException("不存在content:[%s]对应的任务id", content));
	}

	
	public Optional<TextTask> showTask(String dataId) {
		if (data!=null) {
			return data.stream().filter(PredicateSpread.isEqual(TextTask::getDataId, dataId)).findFirst();
		} else {
			return Optional.empty();
		}
	}
	

	public Optional<SuggestionResult> showResultByUrl( String url) {
		return showResult(mapperDataId(url));
	}

	/**
	 * 显示一个最严重 
	 * @return
	 */
	public Optional<SuggestionResult> showSeriousResult() {
		if (data!=null) {
			 return data.stream().map(TextTask::showResult).filter(Optional::isPresent).map(Optional::get)
					 .filter(SuggestionResult::notPass).sorted(SuggestionResult.seriousSorter().reversed()).findFirst();
		} else {
			return Optional.empty();
		}
	}

	public Optional<SuggestionResult> showResult(String dataId) {
		return showTask(dataId).map(TextTask::showResult).map(Optional::get);
	}

	public Optional<Suggestion> showSuggestionByUrl(String url) {
		return showSuggestion(mapperDataId(url));
	}
	
	
	public Optional<Suggestion> showSuggestion(String dataId) {
		Optional<TextTask> taskOptional = showTask(dataId);
		if(taskOptional.isPresent()){
			return taskOptional.get().showSuggestion();
		}
		return Optional.of(Suggestion.review);
	}
	
	
	
	
	
	
	
	
	
	
	

}
