package com.mini.framework.third.kuaidi100.model;

import java.text.ParseException;
import java.util.Date;
import java.util.Optional;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DateUtils;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.exception.standard.UnsupportedException;
import com.mini.framework.third.express.model.ExpressTransportStage;
import com.mini.framework.third.express.model.ExpressTransportStatusItem;
import com.mini.framework.util.string.RegexUtil;

/**
 * 状态明细
 * @author jayheo
 *
 */
public class StatusItem {

	private String context;

	@SerializedName("ftime")
	private String dateString;

	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	public String getDateString() {
		return dateString;
	}

	public void setDateString(String dateString) {
		this.dateString = dateString;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	/**
	 * 解析出状态码
	 * @return
	 */
	public int showState(){
		throw new UnsupportedException("暂时不支持解析状态码");
	}
	
	/**
	 * 2019-09-12 23:04:17
	 * @return
	 */
	public Optional<Date> parseDate(){
		try {
			return Optional.of(DateUtils.parseDate(dateString, "yyyy-MM-dd HH:mm:ss"));
		} catch (ParseException e) {
			return Optional.empty();
		}
	}
	
	public ExpressTransportStatusItem mapperExpressTransport(){
		ExpressTransportStatusItem item = new ExpressTransportStatusItem();
		item.setDate(parseDate().orElse(null));
		item.setContext(context);
		item.setPhone(RegexUtil.getMatch("(\\d{11})", context));
		item.setStage(ExpressTransportStage.guessMatchOne(context).orElse(null));
		return item ;
	}

}
