package com.mini.framework.third.weixin;


import com.mini.framework.core.code.standard.style01.flag.CodeStandardVariableDeclareSingleWord;
import com.mini.framework.core.code.standard.style01.flag.CodeStandardVariableDeclareWord;
import com.mini.framework.core.code.standard.style01.flag.VariableDeclareWord;
import com.mini.framework.util.type.EnumTypeShower;

import java.util.Map;

/**
 * 微信的应用的类型
 * @author jayheo
 */
@CodeStandardVariableDeclareWord(words = {
		@VariableDeclareWord(word = "weixin",comment = "微信"),
		@VariableDeclareWord(word = "appid",comment = "一个微信的应用"),
		@VariableDeclareWord(word = "type",comment = "应用的类型"),
})
public enum WeixinAppidType implements EnumTypeShower<WeixinAppidType> {

	/**
	 * 小程序
	 */
	@CodeStandardVariableDeclareSingleWord(word = "mapp",comment = {"微信小程序","m开头加app代表是小程序"})
	mapp("微信小程序"),


	/**
	 * 原生程序
	 * https://open.weixin.qq.com/cgi-bin/applist?t=manage/list&page=0&num=20&openapptype=1&lang=zh_CN
	 */
	@CodeStandardVariableDeclareSingleWord(word = "papp",comment = {"微信移动应用","p开头加app代表是原生程序"})
	papp("原生程序"),

	/**
	 * 公众号之服务号 
	 */
	@CodeStandardVariableDeclareSingleWord(word = "server",comment = {"微信公众号之服务号"})
	server("微信服务号"),


	/**
	 * 订阅号
	 */
	@CodeStandardVariableDeclareSingleWord(word = "subscribe",comment = {"微信公众号之订阅号"})
	subscribe("微信订阅号"),
	
	;

	@CodeStandardVariableDeclareSingleWord(word = "title",comment = {"名字"})
	private final String title;

	WeixinAppidType(String title) {
		this.title = title;
	}

	public String title() {
		return title;
	}


	/**
	 * 这个方法已废弃
	 * @see #title()
	 * @return
	 */
	@Deprecated
	public String getTitle() {
		return title();
	}

	@Override
	public void fillFieldToMap(Map<String, Object> map) {
		map.put("title",title);
	}
}
