package com.mini.framework.third.weixin.console.model;

import java.util.Optional;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.params.MapParams;

public class WeixinCurlCommand {

	private String url;
	private String cookie;
	
	public WeixinCurlCommand(String url, String cookie) {
		super();
		this.url = url;
		this.cookie = cookie;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}


	public String getCookie() {
		return cookie;
	}

	public void setCookie(String cookie) {
		this.cookie = cookie;
	}
	
	public String getTokenParam(){
		 return queryTokenParam().orElseThrow(()->new BadReqException("command中的url:[%s]必须有token参数", url));
	}
	
	public Optional<String> queryTokenParam(){
		return queryParam("token");
	}
	
	public WeixinCurlCommand setUrlIntParam(String name,int value){
		return setUrlParam(name, value + "");
	}
	public WeixinCurlCommand setUrlParam(String name,String value){
		AssertUtil.assertMethodRequire(name, "name");
		AssertUtil.assertMethodRequire(value, "value");
		Optional<String> paramOptional = queryParam(name);
		if(paramOptional.isPresent()){
			this.url = this.url.replace(name + "=" + paramOptional.get(), name + "=" + value);
		}else{
			this.url = MapParams.build(name, value).toUrlParams(url);
		}
		return this;
	}
	
	public Optional<String> queryParam(String name){
		AssertUtil.assertMethodRequire(url, "url");
		for (String nv : StringUtils.substringAfter(url, "?").split("&")) {
			if(name.equals(nv.split("=")[0])){
				return Optional.of(nv.split("=").length>=2?nv.split("=")[1]:"");
			}
		}
		return Optional.empty();
	}
	

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
