package com.mini.framework.third.weixin.console.server.handler;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.weixin.console.server.model.template.SyncItemResultType;

public abstract class SimpleTemplateSyncHandler implements TemplateSyncHandler{

	private int division = 10;
	
	private long lastWriteDate = System.currentTimeMillis();
	
	private Integer currentItemIndex = 0;
	private Integer currentNewNum = 0;
	private Integer currentUpdateNum = 0;
	private Integer currentReqErrNum = 0;
	private Integer currentInvalidNum = 0;
	
	public SimpleTemplateSyncHandler() {
		super();
	}

	public Integer getCurrentItemIndex() {
		return currentItemIndex;
	}

	public void setCurrentItemIndex(Integer currentItemIndex) {
		this.currentItemIndex = currentItemIndex;
	}

	public Integer getCurrentNewNum() {
		return currentNewNum;
	}

	public void setCurrentNewNum(Integer currentNewNum) {
		this.currentNewNum = currentNewNum;
	}

	public Integer getCurrentUpdateNum() {
		return currentUpdateNum;
	}

	public void setCurrentUpdateNum(Integer currentUpdateNum) {
		this.currentUpdateNum = currentUpdateNum;
	}

	public Integer getCurrentInvalidNum() {
		return currentInvalidNum;
	}

	public void setCurrentInvalidNum(Integer currentInvalidNum) {
		this.currentInvalidNum = currentInvalidNum;
	}

	public Integer getCurrentReqErrNum() {
		return currentReqErrNum;
	}

	public void setCurrentReqErrNum(Integer currentReqErrNum) {
		this.currentReqErrNum = currentReqErrNum;
	}

	@Override
	public void afterOneHandle(String key, SyncItemResultType oneResult) {
		currentItemIndex++;
		switch (oneResult) {
		case newRecord:
			currentNewNum++;
			break;
		case update:
			currentUpdateNum++;
			break;
		case reqError:
			currentReqErrNum++;
			break;
		case same:
		case undo:
			break;
		case invalid:
			currentInvalidNum++;
			break;
		default:
			throw new ServerException(Status.Server.fatalBug,"有同步状态没有处理", oneResult);
		}
		
		boolean haveLongTime = System.currentTimeMillis() - lastWriteDate > 1000;
		if(currentItemIndex%division==0 || haveLongTime){
			writeCurrentStatus();
			lastWriteDate = System.currentTimeMillis();
		}
	}
	
	public abstract SimpleTemplateSyncHandler writeCurrentStatus();
	
	
	@Override
	public void endHandle() {
		writeCurrentStatus();
	}
	
	
	
}
