package com.mini.framework.third.weixin.mapp.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gson.Gson;
import com.mini.framework.core.status.Status.Busy;
import com.mini.framework.third.weixin.mapp.model.MappPhoneResponse;
import com.mini.framework.third.weixin.mapp.model.MappUserInfoResponse;
import com.mini.framework.third.weixin.mapp.model.MappUserInfoSecretResponse;
import com.mini.framework.third.weixin.util.WeixinAesCryptUtil;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * 用户小程序的加解密
 * @author jayheo
 *
 */
public class MappCryptUtil {
	

	private static Logger logger = LogManager.getLogger(MappCryptUtil.class);
	
	public static MappPhoneResponse decryptPhoneData(String encryptedData, String iv, String sessionKey){
		String result = WeixinAesCryptUtil.decryptData(encryptedData, iv, sessionKey);
		return new Gson().fromJson(result, MappPhoneResponse.class);
	}
	
	
	/**
	 * 解密用户信息
	 * @param userInfoCrypt
	 * @param sessionKey
	 */
	public static void decryptUserInfo(MappUserInfoSecretResponse userInfoCrypt, String sessionKey){
		String result = WeixinAesCryptUtil.decryptData(userInfoCrypt.getEncryptedData(), userInfoCrypt.getSecretSession(), sessionKey);
		AssertUtil.assertNotFatal(result!=null, Busy.bug, "解密结果不应该为空userInfoCrypt:[%s],sessionKey:[%s]",userInfoCrypt,sessionKey);
		MappUserInfoResponse userInfo = new Gson().fromJson(result, MappUserInfoResponse.class);
		userInfo.setCrypt(true);
		userInfoCrypt.setCryptUserInfo(userInfo);
	}
	
	
	//TODO 谭雄伟 小程序拿到用户信息时解密出unionid，注意，在没有关注同主体公众号的情况下也要能解决出来 。
	//要复用WeixinAesCryptUtil里的方法
	//{"errMsg":"getUserInfo:ok","rawData":"{\"nickName\":\"谢志豪\",\"gender\":1,\"language\":\"zh_CN\",\"city\":\"长沙\",\"province\":\"湖南\",\"country\":\"中国\",\"avatarUrl\":\"https://wx.qlogo.cn/mmopen/vi_32/DYAIOgq83epsJAzItHWl6NMxFUBYQMCzQB9XS8zjhEtNXT5Tsic8FG1tyAgkOmoKNCXNm2RYibRjNcI7K3PqI8Jg/132\"}","signature":"a1734044cb180875c00f4be8c8245d85af2948f7","encryptedData":"c72GlLBPeSo+8NfO/mkj1taRN4WPU1efedlAwIgNR5nMp98XdMZMxwi4VOd929afUF9NRSL1a5Q0cCrD6x/61pQvhGvhcifHfddNF/18r1Jv4FLG+jKj2we8SQtqA778CWlwbRKhYElkbujZxdC2JrpaGgs59jl6IUUK9m706XUQRESMCUr4HZ+15UWJVVwLBpb15TZoyKcfuy5buD0cVRE5NhndCPJ3LYldxGvnHgV1YhcllvRRSlcGoS7qJs4viTGlmV+xtAU4T2mlPUlQ5rVfhbRED1SywNgXEf208MDOgU8GbCWmGM8sDYEQXwIENwr5lJlTzcgjU7Cp8qyvTLYoBFMDWBU+/jt6xM/LJ29/mtUTLpNDMMTcGro+POb7BWNSYAbgQCmAn5/JnJhxE0mqzHnJ9gJqPzqR7HPirZJ8Gm5yL0bu+nrPzld9fAraJqolOw98kRb6maQ2r5Uhq6mGZDyaoU3mG7vteVzibJLO0C+Hdpn9Cp771hlI977C2qJvBhWdwiW5+zMl9UFGhA==","iv":"mVcdKvRcfDjVhmxvt7Y0Hg==","userInfo":{"nickName":"谢志豪","gender":1,"language":"zh_CN","city":"长沙","province":"湖南","country":"中国","avatarUrl":"https://wx.qlogo.cn/mmopen/vi_32/DYAIOgq83epsJAzItHWl6NMxFUBYQMCzQB9XS8zjhEtNXT5Tsic8FG1tyAgkOmoKNCXNm2RYibRjNcI7K3PqI8Jg/132"}}
	//上面是测试数据，也可通过小程序debug模式，里面拿到用户信息。
	//https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/union-id.html
	
}
