package com.mini.framework.third.weixin.notice.server.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.third.weixin.notice.server.model.WeixinOpenidSureResult;
import com.mini.framework.third.weixin.notice.server.model.resp.EventScanSubNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventUnSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinAskMsg;
import com.mini.framework.util.log.Event5WBuilder;

/**
 * 对于原来微信服务通知处理的增强
 * @author jayheo
 *
 */
public abstract class AbstractWeixinServerNoticeHandlerAdvice extends AbstractWeixinServerNoticeHandler{

	private Logger logger = LogManager.getLogger(AbstractWeixinServerNoticeHandlerAdvice.class);
	
	/**
	 * 处理关注状态
	 * @param appid 公众号appid
	 * @param openid 公众号中用户的openid
	 * @param subscribeStatus 是不是关注，false不关注，true关注
	 */
	protected abstract void handleSubscribeStatusChange(String appid,String openid,boolean subscribeStatus);
	
	

	/**
	 * 这个方法不再使用了可以废弃
	 */
	@Override
	protected void handleSubscribe(WeixinOpenidSureResult openid){
		
	}

	protected void handleEvent(EventUnSubscribeNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		handleSubscribeStatusChange(weixinNotice.getAppid(),weixinNotice.getEventOpenid(),false);
		weixinAskMsg.setNoneContent();
	}
	
	
	
	/**
	 * 处理用户关注
	 * @param weixinNotice
	 * @param weixinAskMsg
	 */
	protected  void handleEvent(EventSubscribeNotice weixinNotice, WeixinAskMsg weixinAskMsg) {
		weixinAskMsg.setContent("感谢你的关注");
		WeixinOpenidSureResult sureUser = weixinNotice.getOpenidUser();
		handleSubscribeStatusChange(weixinNotice.getAppid(),weixinNotice.getEventOpenid(), true);
		if(weixinNotice.haveSceneCode()){//根据微信文档如果有ticket就是扫码关注
			String sceneCode = weixinNotice.showSceneCode().get();
			Event5WBuilder event = Event5WBuilder.event(2, "inviteSubWeixin").who("用户:[%s]", sureUser.getUserId())
					.what("扫码(带code:[%s])关注了:[%s]",sceneCode, weixinNotice.getServAcc()).when("首次关注");//怎么知道是不是首页关注 见 EventSubscribeNotice
			logger.debug(event);
			this.handleSceneInvite(weixinNotice.getWeixinNoticeType(), sureUser, sceneCode);
		}
	}
	
	
	
	/**
	 * 处理微信扫码进入公众号的的请求
	 * @param weixinNotice
	 * @param weixinAskMsg
	 */
	protected void handleEvent(EventScanSubNotice weixinNotice, WeixinAskMsg weixinAskMsg){
		//参考报文 event.scan.xml
		String sceneCode = weixinNotice.getEventKey();
		WeixinOpenidSureResult sureUser = weixinNotice.getOpenidUser();
		Event5WBuilder event = Event5WBuilder.event(2, "inviteSubWeixin").who("用户:[%s]", sureUser.getUserId())
				.what("扫码(带code:[%s])关注了:[%s]",sceneCode, weixinNotice.getServAcc()).when("该用户已关注了公众号");//怎么知道是不是首页关注 见 EventSubscribeNotice
		logger.debug(event);
		this.handleSceneInvite(weixinNotice.getWeixinNoticeType(),weixinNotice.getOpenidUser(), sceneCode);
	}
	
	
	
}
