package com.mini.framework.third.weixin.notice.server.model;

import java.util.HashMap;
import java.util.Map;

import com.mini.framework.third.weixin.notice.server.model.resp.EventClickNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventScanCodeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventScanSubNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventTemplateResultNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventUnSubscribeNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventViewNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.EventWeixinAwakeSessionNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.FileNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.ImageNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.LinkNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.LocationNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.MappPageNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.ShortvideoNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.TextNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.VideoNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.VoiceNotice;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinNotice;
import com.mini.framework.util.asserts.AssertUtil;

//https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140454
/**
 * 微信通知类型
 * @author jayheo
 *
 */
public enum WeixinNoticeType {
	file("file",FileNotice.class),
	text("text",TextNotice.class),
	image("image",ImageNotice.class),
	voice("voice",VoiceNotice.class),
	video("video",VideoNotice.class),
	shortvideo("shortvideo",ShortvideoNotice.class),
	location("location",LocationNotice.class),
	link("link",LinkNotice.class),
	mappPage("miniprogrampage",MappPageNotice.class),
	eventScancodeWaitmsg("event.scancode_waitmsg",EventScanCodeNotice.class),
	eventScancodePush("event.scancode_push",EventScanCodeNotice.class),
	eventView("event.VIEW",EventViewNotice.class),
	eventUnsubscribe("event.unsubscribe",EventUnSubscribeNotice.class),
	//用户未关注时，扫描带参数二维码事件
	eventSubscribe("event.subscribe",EventSubscribeNotice.class),
	//用户已关注时，扫描带参数二维码事件
	eventScan("event.SCAN",EventScanSubNotice.class),
	eventClick("event.CLICK",EventClickNotice.class),
	//TODO 微信目前有file类型，直接在公众号上面发文件，但是文档上没
	eventTemplateResult("event.TEMPLATESENDJOBFINISH",EventTemplateResultNotice.class),
	
	
	/**
	 * 用户在小程上唤醒客服
	 */
	eventMappAwake("event.user_enter_tempsession",EventWeixinAwakeSessionNotice.class)
	
	
	
	
	;
	private String type;
	
	private Class<? extends WeixinNotice> clazz;
	
	
	
	private static Map<String,WeixinNoticeType> enumMap;
	private static Map<String,WeixinNoticeType> enumMap(){
		if(enumMap==null){
			Map<String,WeixinNoticeType> temp = new HashMap<>();
			for (WeixinNoticeType weixinNoticeType : WeixinNoticeType.values()) {
				temp.put(weixinNoticeType.type, weixinNoticeType);
			}
			enumMap = temp;
		}
		return enumMap;
	}
	
	
	/**
	 * 根据字符串得到 {@link WeixinNoticeType}
	 * 这里要注意异常  java.lang.IllegalArgumentException: No enum constant com.aquke.study.model.type.WeixinNoticeType.file
	 * @param type
	 * @return
	 */
	public static WeixinNoticeType get(String type) {
		WeixinNoticeType noticeType = enumMap().get(type);
		AssertUtil.assertNotNull(noticeType, "WeixinNoticeType中没有与%s对应的实体类", type);
		return noticeType;
	}
	
	WeixinNoticeType(String type,Class<? extends WeixinNotice> clazz) {
		this.type = type;
		this.clazz = clazz;
	}

	public String getType() {
		return type;
	}


	public Class<? extends WeixinNotice> getClazz() {
		return clazz;
	}

}
