package com.mini.framework.third.weixin.notice.server.model.resp;

import java.util.Optional;

import com.mini.framework.third.weixin.notice.server.model.able.IfHaveInviteCode;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 *  当用户已关注了，
 *  且通过有推荐码的二维码进来的。
 *  会出来这个事件
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class EventScanSubNotice extends EventNotice implements IfHaveInviteCode {
	@XStreamAlias("Ticket")
	private String ticket;

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	@Override
	public Optional<String> showSceneCode() {
		return Optional.ofNullable(getEventKey());
	}

}
