package com.mini.framework.third.weixin.notice.server.model.resp;

import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.third.weixin.notice.server.model.WeixinNoticeType;
import com.mini.framework.third.weixin.notice.server.model.WeixinOpenidSureResult;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 微信通知
 * @author jayheo
 * TODO https://developers.weixin.qq.com/doc/offiaccount/Account_Management/Wechat_Accreditation_Event_Push.html
 * 等商家多起来的时候添加  资质认证成功（此时立即获得接口权限）
 */
public class WeixinNotice implements ServerAndUserShower{
	/**
	 * appid
	 */
	private String appid;
	/**
	 * 消息的唯一id
	 */
	@XStreamAlias("MsgId")
	private String msgId;
	/**
	 * 系统接收到的时间
	 */
	private Date receiveDate;
	/**
	 * 微信确认的消息生成时间
	 */
	@XStreamAlias("CreateTime")
	private int createDate;
	
	/**
	 * 事件相关的openId
	 */
	@XStreamAlias("FromUserName")
	private String eventOpenid;
	
	@XStreamAlias("MsgType")
	private String type;
	
	/**
	 * 事件相关的服务帐号
	 */
	@XStreamAlias("ToUserName")
	private String servAcc;
	
	
	/**
	 * 加密码的编码
	 * TODO 这里可以检查数据是不是真的来自微信服务
	 */
	@XStreamAlias("Encrypt")
	private String encrypt;
	
	
	/**
	 * 事件关联的用户id
	 * 一般一个事件都是一个用户触发的，
	 * 如果是有用户的话，就能关联到用户id
	 */
	private WeixinOpenidSureResult openidUser;
	
	/**
	 * 原型的xml报文
	 */
	private String originXmlMessage;
	
	
	/**
	 * 从一些事件通知知道是不是取消了关注，
	 * 一般情况下是关注的，但有个别事情是代表已取消关注，比如取消关注的回调。
	 * 如果是取消关注就重写这个方法
	 * @return
	 */
	public boolean cancelSubscribe(){
		return false;
	}
	
	public String getServAcc() {
		return servAcc;
	}
	private WeixinNoticeType weixinNoticeType;
	
	public String getAppid() {
		return appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}
	public String getMsgId() {
		return msgId;
	}
	public void setMsgId(String msgId) {
		this.msgId = msgId;
	}
	public Date getReceiveDate() {
		return receiveDate;
	}
	public void setReceiveDate(Date receiveDate) {
		this.receiveDate = receiveDate;
	}
	public int getCreateDate() {
		return createDate;
	}
	public void setCreateDate(int createDate) {
		this.createDate = createDate;
	}
	
	public String getEventOpenid() {
		return eventOpenid;
	}
	public void setEventOpenid(String eventOpenid) {
		this.eventOpenid = eventOpenid;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	
	public WeixinOpenidSureResult getOpenidUser() {
		return openidUser;
	}
	public void setOpenidUser(WeixinOpenidSureResult openidUser) {
		this.openidUser = openidUser;
	}
	public WeixinNoticeType getWeixinNoticeType() {
		return weixinNoticeType;
	}
	public void setWeixinNoticeType(WeixinNoticeType weixinNoticeType) {
		this.weixinNoticeType = weixinNoticeType;
	}
	
	public String getOriginXmlMessage() {
		return originXmlMessage;
	}

	public void setOriginXmlMessage(String originXmlMessage) {
		this.originXmlMessage = originXmlMessage;
	}

	public String getEncrypt() {
		return encrypt;
	}
	public void setEncrypt(String encrypt) {
		this.encrypt = encrypt;
	}
	@Override
	public String showOpenid() {
		return eventOpenid;
	}
	@Override
	public String showServAcc() {
		return servAcc;
	}
	@Override
	public void setServAcc(String servAcc) {
		this.servAcc = servAcc;
	}
	@Override
	public void setOpenid(String openid) {
		this.eventOpenid = openid;
	}
	
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
