package com.mini.framework.third.weixin.oauth2;

import com.mini.framework.third.weixin.server.client.WeixinServerAccountSdk;
import com.mini.framework.third.weixin.server.client.WeixinServerSdkSimpleImpl;
import com.mini.framework.third.weixin.server.model.WeixinServerAccountAccess;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;
import com.mini.framework.third.weixin.server.provider.WeixinServerAccessProvider;

/**
 * 微信的oauth2 客户端。
 * 这个是可以通用的。
 * @author jayheo
 */
public class Oauth2Client {

    private WeixinServerAccountSdk sdk;

    private static WeixinServerAccountSdk createServerSdkImpl(String secret,String appid){
        WeixinServerSdkSimpleImpl sdk = new WeixinServerSdkSimpleImpl();
        WeixinServerAccountAccess access = new WeixinServerAccountAccess(secret,appid,null);
        sdk.setWeixinServerAccessProvider(WeixinServerAccessProvider.createInstance(access));
        sdk.setServer(WeixinServerSdkSimpleImpl.defaultWeixinApiHost);
        //因为使用了  WeixinServerSdkSimpleImpl 这里的 appidType 会直接传 值为 WeixinAppidType.server 忽略即可。
        sdk.setSiteTokenProvider(appidType->secret);
        return sdk;
    }


    /**
     * 通过一个老的方式，得到客户端。
     * @param appid
     * @param secret
     * @return
     */
    public static Oauth2Client createClientByServerAccount(String appid,String secret){
        Oauth2Client client = new Oauth2Client();
        client.sdk = createServerSdkImpl(secret, appid);
        return client;
    }


    public WeixinServerUserDetail queryAuthByCode(String code){
        return sdk.queryAuthByCode(code);
    }
}
