package com.mini.framework.third.weixin.pay.client;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.XStreamUtil;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.weixin.util.ReqResqSafeUtil;

/**
 * 支持md5签名的
 * @author jayheo
 *
 */
public interface MessageMd5Signable {
	default public Map<String, String> toSignMap(){
		Map<String, String> map = XStreamUtil.beanToMap(this);
		map.remove("sign");
		map.remove("key");
		return map;
	}
	

	public String showSign();
	
	public void fillSign(String sign);
	/**
	 * 用文字表达报文类型
	 * @return
	 */
	public String messageType();
	
	default public void sign(String key){
		Map<String, String> params = toSignMap();
		String sign = ReqResqSafeUtil.md5Sign(params, key);
		this.fillSign(sign);
	}
	
	/**
	 * 验证签名
	 * @param key
	 */
	default public void verify(String key){
		Map<String, String> params = toSignMap();
		boolean safe = StringUtils.equals(showSign(), ReqResqSafeUtil.md5Sign(params,key));
		AssertUtil.simpleAssertByStatus(safe, Status.Third.weixin, "%s报文验签失败",messageType());
	}
}
