package com.mini.framework.third.weixin.server.comm;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.model.menu.WeixinServerMenu;
import com.mini.framework.util.string.GsonUtil;

/**
 * 默认菜单
 * @author jayheo
 */
//https://developers.weixin.qq.com/doc/offiaccount/Custom_Menus/Querying_Custom_Menus.html
public class DefaultMenuResonpse{

	@SerializedName("is_menu_open")
	private Integer useStatus;
	
	@SerializedName("selfmenu_info")
	private WeixinServerMenu menu;

	public Integer getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Integer useStatus) {
		this.useStatus = useStatus;
	}

	public WeixinServerMenu getMenu() {
		return menu;
	}

	public void setMenu(WeixinServerMenu menu) {
		this.menu = menu;
	}
	
	public static DefaultMenuResonpse fromJson(String json){
		return GsonUtil.createBaseBuilder(WeixinServerMenu.gsonBulderOperator()).create().fromJson(json, DefaultMenuResonpse.class);
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	
}
