package com.mini.framework.third.weixin.server.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;

import com.mini.framework.util.string.StringUtil;
import com.mini.framework.core.exception.HandleEnDeCodeException;

public class ServerJsapiTicketResponse {

	//@XStreamAlias("url")
	private String url;

	//@XStreamAlias("jsapi_ticket")
	private String ticket;

	//@XStreamAlias("nonceStr")
	private String nonceStr;

	//@XStreamAlias("signature")
	private String signature;

	private String timestamp;

	//@XStreamAlias("appid")
	private String appid;

	public ServerJsapiTicketResponse(String url, String ticket, String appid) {
		super();
		nonceStr = RandomStringUtils.randomNumeric(16);
		timestamp = String.valueOf(System.currentTimeMillis() / 1000);
		this.url = url;
		this.ticket = ticket;
		this.appid = appid;
	}
	
	public ServerJsapiTicketResponse(){
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSignature() {
		return signature;
	}

	public void setSignature(String signature) {
		this.signature = signature;
	}

	public String getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(String timestamp) {
		this.timestamp = timestamp;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}
	

	public ServerJsapiTicketResponse sign() {
		String params = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", ticket, nonceStr,timestamp, url);
		MessageDigest crypt = createSHA1Digest();
        crypt.reset();
        crypt.update(StringUtil.getUtf8Byte(params));
        signature = Hex.encodeHexString(crypt.digest());
        return this;
	}
	
	private MessageDigest createSHA1Digest(){
		try {
			return MessageDigest.getInstance("SHA-1");
		} catch (NoSuchAlgorithmException e) {
			//ignore 
			throw new HandleEnDeCodeException(e, "取SHA-1出现异常");
		}
	}
}
