package com.mini.framework.third.weixin.server.model.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.util.asserts.AssertUtil;

public class WeixinServerButton {

	@SerializedName("type")
	private WeixinServerButtonType type;
	
	@SerializedName("name")
	private String name;
	
	@SerializedName("key")
	private String key;
	
	@SerializedName("url")
	private String url;
	
	@SerializedName("appid")
	private String appid;
	
	@SerializedName("pagepath")
	private String namespace;
	
	@SerializedName("sub_button")
	private List<WeixinServerButton> subButtons;

	public WeixinServerButtonType getType() {
		return type;
	}

	public void setType(WeixinServerButtonType type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getNamespace() {
		return namespace;
	}

	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}
	
	public List<WeixinServerButton> getSubButtons() {
		return subButtons;
	}

	public void setSubButtons(List<WeixinServerButton> subButtons) {
		this.subButtons = subButtons;
	}

	public WeixinServerButton(WeixinServerButtonType type, String name, String key, String url, String appid,
			String namespace) {
		super();
		this.type = type;
		this.name = name;
		this.key = key;
		this.url = url;
		this.appid = appid;
		this.namespace = namespace;
	}
	
	/**
	 * 生成一个链接到url的按钮
	 * @param name
	 * @param url
	 * @param key
	 * @return
	 */
	public static WeixinServerButton createLinkUrlButton(String name,String key,String url){
		return new WeixinServerButton(WeixinServerButtonType.link, name, key, url, null,null);
	}
	
	/**
	 * 生成一个链接到小程序的按钮
	 * 如果旧版微信打不开小程序，可以走默认的defaultUrl
	 * @param name
	 * @param key
	 * @param appid
	 * @param namespace
	 * @param defaultUrl 如果旧版微信打不开小程序，可以走默认url
	 * @return
	 */
	public static WeixinServerButton createLinkMappButton(String name,String key,String appid,String namespace,String defaultUrl){
		return new WeixinServerButton(WeixinServerButtonType.linkMapp, name, key, defaultUrl, appid,namespace);
	}
	
	/**
	 * 通过类型生成按钮
	 * @param type
	 * @param name
	 * @param key
	 * @return
	 */
	public static WeixinServerButton createButtonByType(WeixinServerButtonType type,String name,String key){
		AssertUtil.assertSupport(!type.matchType(WeixinServerButtonType.linkMapp), "linkMapp不能使用这个方法");		
		AssertUtil.assertSupport(!type.matchType(WeixinServerButtonType.link), "linkMapp不能使用这个方法");		
		return new WeixinServerButton(type, name, key,null,null,null);
	}
	
	public List<WeixinServerButton> sureHaveSubList(){
		subButtons = Optional.ofNullable(subButtons).orElse(new ArrayList<>());
		return subButtons;
	}
	
	public WeixinServerButton addSubButton(WeixinServerButton button){
		sureHaveSubList().add(button);
		return this;
	}
	
	
	/**
	 * 如果没有类型把当成组
	 * @return
	 */
	public WeixinServerButtonType showTypeIfGroup(){
		if(subButtons!=null){
			return Optional.ofNullable(type).orElse(WeixinServerButtonType.group);
		}
		return type;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
}
