package com.mini.framework.third.weixin.server.util.tpmsg;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.JsonEditUtil;

public class WeixinTempAdapter {
	
	/**
	 * <pre>
	 * 输入的例子：
	 * {
    "primary_industry": {
        "first_class": "IT科技",
        "second_class": "互联网|电子商务"
    },
    "secondary_industry": {
        "first_class": "消费品",
        "second_class": "消费品"
    }
}
输出例子

<pre>
	 * 
	 * @param industryJson
	 * @return
	 */
	public static List<String> getIndustrysFromJson(String industryJson){
		AssertUtil.assertMethodRequire(industryJson, "industryJson");
		List<WeixinServerIndustryDto> industrys = parseIndustrysFromJson(industryJson);
		return industrys.stream().map(WeixinServerIndustryDto::industrysName).collect(Collectors.toList());
	}
	
	
	public static List<WeixinServerIndustryDto> parseIndustrysFromJson(String industryJson){
		AssertUtil.assertMethodRequire(industryJson, "industryJson");
		String[][] namespaces = new String[][]{
				new String[]{"primary_industry","first_class"},
				new String[]{"primary_industry","second_class"},
				new String[]{"secondary_industry","first_class"},
				new String[]{"secondary_industry","second_class"},
		};
		List<String> matchs = JsonEditUtil.getJsonMapNamespaceValues(industryJson, namespaces );
		//这里要么解决错误，要么就能返回4个值供以下面使用
		WeixinServerIndustryDto primaryIndustry = new WeixinServerIndustryDto(true, matchs.get(0),matchs.get(1));
		WeixinServerIndustryDto secondaryIndustry = new WeixinServerIndustryDto(false, matchs.get(2),matchs.get(3));
		//TODO 
		return Stream.of(primaryIndustry,secondaryIndustry).filter(WeixinServerIndustryDto::existence).collect(Collectors.toList());
	}
	
	
	
	
}
