package com.mini.framework.third.weixin.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Map.Entry;

import org.apache.commons.codec.digest.DigestUtils;

import com.mini.framework.util.string.UnSplitUtil;

/**
 * 微信通讯安全
 * @author jayheo
 *
 */
public class ReqResqSafeUtil {

	public static String md5Sign(Map<String, String> params, String signKey) {
		//以key就行ascii排序。
		Map<String, String> sortedMap = new TreeMap<String, String>(params);
		//去掉不需要的东西
		sortedMap.remove("sign");
		sortedMap.remove("key");
		//去掉空
		Iterator<Entry<String, String>> it = params.entrySet().iterator();
		while (it.hasNext()) {
			if(it.next().getValue()==null){
				it.remove();
			}
		}
		LinkedHashMap<String, String> linkedMap = new LinkedHashMap<>(sortedMap);

		//把key放在最后面。
		linkedMap.put("key", signKey);
		String toSign = UnSplitUtil.toParamString(linkedMap);
		return DigestUtils.md5Hex(toSign.toString()).toUpperCase();
	}
}
