package com.mini.framework.third.weixin.wxpay.v3.client;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.GsonUtil;

import java.util.HashMap;

/**
 * @author jayheo
 */
public class ErrorResponse {
    
    @SerializedName("code")
    private String status;
    @SerializedName("message")
    private String message;

    @SerializedName("detail")
    private HashMap<String ,Object> detail;
    
    public static ErrorResponse fromJson(String json){
        AssertUtil.assertMethodRequire(json,"json");
        return GsonUtil.buildMilliSecondDateGson().fromJson(json, ErrorResponse.class);
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public HashMap<String, Object> getDetail() {
        return detail;
    }

    public void setDetail(HashMap<String, Object> detail) {
        this.detail = detail;
    }
}
