package com.mini.framework.third.weixin.wxpay.v3.exception;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.ThirdException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.weixin.wxpay.v3.client.ErrorResponse;

/**
 * 微信支付之 错误体
 * @author jayheo
 */
public class WxpayBadRequestException extends ThirdException {

    private ErrorResponse errorResponse;

    public WxpayBadRequestException(ErrorResponse errorResponse, String message, Object... msgParams) {
        super(Status.Server.programConfigJava, message, msgParams);
        this.errorResponse = errorResponse; 
    }

    public ErrorResponse getErrorResponse() {
        return errorResponse;
    }
}
