package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;

/**
 * https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_3_9.shtml
 * @author jayheo
 */
public class WxpayRefundPayOrderResponse extends WxpayResponse  {

    /**
     * 商户付款的订单号<BR>
     * string[6,32]<BR>
     * 必填：是<br>
     * 商户系统内部订单号，只能是数字、大小写字母_-*且在同一个商户号下唯一<BR>
     * 例如:1217752501201407033233368018<BR>
     */
    @SerializedName("out_trade_no")
    private String sitePayOrderNumber;


    /**
     * 微信支付订单号<BR>
     * 微信支付系统生成的订单号。<BR>
     * 例如:1217752501201407033233368018
     */
    @SerializedName("transaction_id")
    private String wxpayPayOrderNumber;


    /**
     * 商户退款单号<BR>
     * string[6,32]<BR>
     * 必填：是<br>
     * 商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。<BR>
     * 例如:1217752501201407033233368018<BR>
     */
    @SerializedName("out_refund_no")
    private String siteRefundOrderNumber;


    /**
     * 微信侧 的退款单号。
     * 例如:50000000382019052709732678859
     */
    @SerializedName("refund_id")
    private String wxpayRefundOrderNumber;


    /**
     * 	退款到银行发现用户的卡作废或者冻结了，导致原路退款银行卡失败，可前往商户平台-交易中心，手动处理此笔退款。
     * 	枚举值：
     * SUCCESS：退款成功
     * CLOSED：退款关闭
     * PROCESSING：退款处理中
     * ABNORMAL：退款异常
     */
    @SerializedName("status")
    private String status;


    public String getSitePayOrderNumber() {
        return sitePayOrderNumber;
    }

    public void setSitePayOrderNumber(String sitePayOrderNumber) {
        this.sitePayOrderNumber = sitePayOrderNumber;
    }

    public String getWxpayPayOrderNumber() {
        return wxpayPayOrderNumber;
    }

    public void setWxpayPayOrderNumber(String wxpayPayOrderNumber) {
        this.wxpayPayOrderNumber = wxpayPayOrderNumber;
    }

    public String getSiteRefundOrderNumber() {
        return siteRefundOrderNumber;
    }

    public void setSiteRefundOrderNumber(String siteRefundOrderNumber) {
        this.siteRefundOrderNumber = siteRefundOrderNumber;
    }

    public String getWxpayRefundOrderNumber() {
        return wxpayRefundOrderNumber;
    }

    public void setWxpayRefundOrderNumber(String wxpayRefundOrderNumber) {
        this.wxpayRefundOrderNumber = wxpayRefundOrderNumber;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
