package com.mini.framework.third.aliyun;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.green.model.v20180509.ImageSyncScanRequest;
import com.aliyuncs.green.model.v20180509.TextScanRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.mini.framework.core.exception.ThirdException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.aliyun.model.content.ContentGreenPhotoResponse;
import com.mini.framework.third.aliyun.model.content.ContentGreenTextResponse;
import com.mini.framework.third.aliyun.model.content.SuggestionResult;
import com.mini.framework.third.aliyun.model.content.photo.PhotoScene;
import com.mini.framework.third.aliyun.model.content.text.TextScene;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.StringUtil;
import com.mini.framework.util.string.gson.builder.GsonData;

/**
 * 内容绿化帮助
 * @author jayheo
 *
 */
public class ContentGreenHelper {
	
	private static Logger logger = LogManager.getLogger(ContentGreenHelper.class);
	
	private static int textMax = 5000;
	
	public static DefaultProfile createProfile(String accessKeyId, String secret){
		return DefaultProfile.getProfile("cn-shanghai", accessKeyId,secret);
	}
	
	/**
	 * 简单的查询一个数据
	 * @param profile
	 * @param content
	 * @param scenes 
	 * @return
	 */
	public static Optional<SuggestionResult> simpleSingleTextAnalysis(IClientProfile profile,String content, TextScene[] scenes){
		AssertUtil.assertMethodRequire(content, "content");
		if(content.length()>textMax){
			Set<String> contents = new HashSet<String>();
			while(content.length()>textMax){
				contents.add(content.substring(0, 5000));
				content = content.substring(5000);
			}
			return simpleTextAnalysis(profile, contents, scenes).showSeriousResult();
		}
		ContentGreenTextResponse resp = simpleTextAnalysis(profile, Stream.of( content).collect(Collectors.toSet()),scenes);
		return resp.showSeriousResult();
	}
	
	
	//https://help.aliyun.com/document_detail/53427.html?spm=a2c4g.11186623.6.712.211d75443s3h2h
	/**
	 * 简单的返回解析结果
	 * @param profile
	 * @param contents
	 * @return
	 */
	public static ContentGreenTextResponse simpleTextAnalysis(IClientProfile profile,Set<String> contents,TextScene[] scenes){
        String reqBody = GsonData.build().param("scenes", scenes)
        .array("tasks", array->{
        	for (String content : contents) {
        		AssertUtil.assertSupport(content!=null, "内容中不允许使用空指针");
        		array.add(GsonData.build().param("dataId",DigestUtils.md5Hex(content)).param("content",content));
			}
        }).toJson();
        Event5WBuilder event = Event5WBuilder.event(1, "ContentGreen-simpleTextAnalysis").what("检查文本请求reqJson:[%s]", reqBody);
        String respJson = requestJson(profile,new TextScanRequest(), reqBody, 3000, 60000);
        event.result("得到结果respJson:[%s]", respJson);
        logger.debug(event.create());
        ContentGreenTextResponse respBean = ContentGreenTextResponse.fromJson(ContentGreenTextResponse.class, respJson);
        return respBean;
	}
	
	public static Optional<SuggestionResult> simpleSinglePhotoAnalysis(IClientProfile profile,String url, PhotoScene[] scenes){
		AssertUtil.assertMethodRequire(url, "url");
		ContentGreenPhotoResponse resp = simplePhotoAnalysis(profile, Stream.of( url).collect(Collectors.toSet()),scenes);
		return resp.showResultByUrl(url);
	}
	
	public static ContentGreenPhotoResponse simplePhotoAnalysis(IClientProfile profile,Set<String> urls,PhotoScene[] scenes){
		//https://help.aliyun.com/document_detail/70292.html?spm=a2c4g.11186623.2.11.62441e7fmPKAIi#reference-fzy-ztm-v2b
        String reqBody = GsonData.build().param("scenes",scenes)
        .array("tasks", array->{
        	for (String url : urls) {
        		AssertUtil.assertSupport(url!=null, "url不允许使用空指针");
        		array.add(GsonData.build().param("dataId",DigestUtils.md5Hex(url)).param("url",url));
			}
        }).toJson();
        Event5WBuilder event = Event5WBuilder.event(1, "ContentGreen-simplePhotoAnalysis").what("检查图片请求reqJson:[%s]", reqBody);
        String respJson = requestJson(profile,new ImageSyncScanRequest(), reqBody, 3000, 60000);
        		event.result("得到结果respJson:[%s]", respJson);
        logger.debug(event.create());
        ContentGreenPhotoResponse respBean = ContentGreenPhotoResponse.fromJson(ContentGreenPhotoResponse.class, respJson);
        return respBean;
	}
	
	
	public static String requestJson(IClientProfile profile,AcsRequest<?> textScanRequest, String jsonReqBody,int connectTimeout,int readTimeout){
        IAcsClient client = new DefaultAcsClient(profile);
		textScanRequest.setAcceptFormat(FormatType.JSON);
		textScanRequest.setHttpContentType(FormatType.JSON);
        textScanRequest.setMethod(com.aliyuncs.http.MethodType.POST);
        textScanRequest.setEncoding("UTF-8");
        textScanRequest.setRegionId(profile.getRegionId());
        textScanRequest.setHttpContent( StringUtil.getUtf8Byte(jsonReqBody), "UTF-8", FormatType.JSON);
        textScanRequest.setConnectTimeout(connectTimeout);
        textScanRequest.setReadTimeout(readTimeout);
        textScanRequest.setProtocol(ProtocolType.HTTPS);
		try {
			HttpResponse textScanResponse = client.doAction(textScanRequest);
			if(!textScanResponse.isSuccess()){
				throw new ThirdException(Status.Third.aliyunConnent, "发起到阿里云的连接出错,status:%s",textScanResponse.getStatus());
			} 
			String respJson = textScanResponse.getHttpContentString();
			return respJson;
		} catch (ServerException e) {
			throw new ThirdException(e,Status.Third.aliyunConnent, "发起到阿里云的连接出错,服务端错误");
		} catch (ClientException e) {
			throw new ThirdException(e,Status.Third.aliyunConnent, "发起到阿里云的连接出错,客户端错误");
		}
        
	}
	
}
