package com.mini.framework.third.aliyun.model.content.photo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.mini.framework.third.aliyun.model.content.SuggestionResult;
import com.mini.framework.third.aliyun.model.content.type.Suggestion;

public class PhotoResult {

	private PhotoSceneItem label;
	private Double rate;
	private PhotoScene scene;
	private Suggestion suggestion;
	private List<PhotoScenePhotoContent> sfaceData;

	public PhotoSceneItem getLabel() {
		return label;
	}

	public void setLabel(PhotoSceneItem label) {
		this.label = label;
	}

	public Double getRate() {
		return rate;
	}

	public void setRate(Double rate) {
		this.rate = rate;
	}

	public PhotoScene getScene() {
		return scene;
	}

	public void setScene(PhotoScene scene) {
		this.scene = scene;
	}

	public Suggestion getSuggestion() {
		return suggestion;
	}

	public void setSuggestion(Suggestion suggestion) {
		this.suggestion = suggestion;
	}
	
	public List<PhotoScenePhotoContent> getSfaceData() {
		return sfaceData;
	}

	public void setSfaceData(List<PhotoScenePhotoContent> sfaceData) {
		this.sfaceData = sfaceData;
	}

	public SuggestionResult showResult(){
		List<PhotoScenePhotoContent>sfaceData = this.sfaceData ==null?(new ArrayList<>()):this.sfaceData;
		String desc = String.format("图片中发现%s,%s%%内容:%s",label.simpleDesc(),rate,sfaceData.stream().map(PhotoScenePhotoContent::showCousesDesc).collect(Collectors.toList()));
		return new SuggestionResult(suggestion,desc );
	}
	
	public boolean ifBlack(){
		return label==null || label.ifBlack();
	}
	
	public static Comparator<PhotoResult> seriousSorter(){
		return Comparator.comparing(PhotoResult::getSuggestion, Suggestion.seriousSorter());
	}

}
