package com.mini.framework.third.aliyun.model.content.photo;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import com.mini.framework.third.aliyun.model.content.SuggestionResult;
import com.mini.framework.third.aliyun.model.content.type.Suggestion;

public class PhotoTask {

	private Integer code;
	private String dataId;
	private String msg;
	private List<PhotoResult> results;
	private String taskId;
	private String url;

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDataId() {
		return dataId;
	}

	public void setDataId(String dataId) {
		this.dataId = dataId;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public List<PhotoResult> getResults() {
		return results;
	}

	public void setResults(List<PhotoResult> results) {
		this.results = results;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}
	
	public Optional<Suggestion> showSuggestion(){
		return showResult().map(SuggestionResult::getSuggestion);
	}
	
	public Optional<SuggestionResult> showResult(){
		List<PhotoResult>results = this.results==null?new ArrayList<>():this.results;
		results = results.stream().filter((PhotoResult::ifBlack)).collect(Collectors.toList());
		if(results.isEmpty()){
			return Optional.empty();
		}else{
			return results.stream().sorted(PhotoResult.seriousSorter().reversed()).map(PhotoResult::showResult).findFirst();
		}
	}

}
