package com.mini.framework.third.aliyun.model.content.text;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.third.aliyun.model.content.SuggestionResult;
import com.mini.framework.third.aliyun.model.content.type.Suggestion;

//https://help.aliyun.com/document_detail/70439.html?spm=a2c4g.11174283.6.664.7a1174879B6ARd
public class TextResult {

	/**
	 * details	数组	否	命中风险的详细信息。具体结构描述见detail。
	 */
	private List<TextResultDetail> details;
	
	/**
	 * extras	JSON对象	否	附加信息。例如，命中了您自定义的词库时，返回词库code。该值将来可能会调整，建议您不要在业务上进行依赖。
	 */
	private String extras; 
	
	/**
	 * label	字符串	是	检测结果的分类，与具体的scene对应。取值范围参考scene 和 label说明。
	 * https://help.aliyun.com/document_detail/70439.html?spm=a2c4g.11186623.2.12.64853db3cffDt7#reuse-scene
	 */
	private TextAntispamSceneItem label;
	/**
	 * rate	浮点数	是	结果为该分类的概率，取值范围为[0.00-100.00]。值越高，表示越有可能属于该分类。
说明 分值仅供参考，您需要关注label和suggestion内容。
	 */
	private Double rate;
	/**
	 * scene	字符串	是	检测场景，和调用请求中的场景对应。
	 */
	private String scene;
	/**
	 * <pre>
	 * 建议用户执行的操作，取值范围：
	 * pass：文本正常
	 * review：需要人工审核
	 * block：文本违规，可以直接删除或者做限制处理
	 * </pre>
	 */
	private Suggestion suggestion;

	public TextAntispamSceneItem getLabel() {
		return label;
	}

	public void setLabel(TextAntispamSceneItem label) {
		this.label = label;
	}

	public String getScene() {
		return scene;
	}

	public void setScene(String scene) {
		this.scene = scene;
	}

	public Suggestion getSuggestion() {
		return suggestion;
	}

	public void setSuggestion(Suggestion suggestion) {
		this.suggestion = suggestion;
	}

	public Double getRate() {
		return rate;
	}

	public void setRate(Double rate) {
		this.rate = rate;
	}

	public List<TextResultDetail> getDetails() {
		return details;
	}

	public void setDetails(List<TextResultDetail> details) {
		this.details = details;
	}

	public String getExtras() {
		return extras;
	}

	public void setExtras(String extras) {
		this.extras = extras;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	public boolean ifBlack(){
		return label.ifBlack(rate);
	}
	
	
	public SuggestionResult showCauseResult(){
		List<TextResultDetail> details = this.details==null?new ArrayList<>():this.details;
		List<String> causes = details.stream().map(TextResultDetail::showCousesDesc).collect(Collectors.toList());
		return new SuggestionResult(suggestion, String.format("文字中发现%s,%s%%内容:%s" , label.simpleDesc() ,rate,causes));
	}
	
	
	public static Comparator<TextResult> seriousSorter(){
		return Comparator.comparing(TextResult::getSuggestion, Suggestion.seriousSorter());
	}

}
