package com.mini.framework.third.aliyun.model.content.text;

import java.util.List;
import java.util.Optional;

import com.mini.framework.third.aliyun.model.AbstractAliyunResponse;
import com.mini.framework.third.aliyun.model.content.SuggestionResult;
import com.mini.framework.third.aliyun.model.content.type.Suggestion;

public class TextTask extends AbstractAliyunResponse {

	private String content;
	private String dataId;
	private String taskId;

	private List<TextResult> results;

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getDataId() {
		return dataId;
	}

	public void setDataId(String dataId) {
		this.dataId = dataId;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public List<TextResult> getResults() {
		return results;
	}

	public void setResults(List<TextResult> results) {
		this.results = results;
	}
	
	public Optional<Suggestion> showSuggestion(){
		return showResult().map(SuggestionResult::getSuggestion);
	}
	
	public Optional<SuggestionResult> showResult(){
		if(results!=null){
			return results.stream().sorted(TextResult.seriousSorter().reversed()).filter(TextResult::ifBlack).map(TextResult::showCauseResult).findFirst();
		}else{
			return Optional.empty();
		}
	}

}
