package com.mini.framework.third.cl253;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.third.cl253.comm.SendSmsCommRequest;
import com.mini.framework.third.cl253.comm.SendSmsCommResponse;
import com.mini.framework.third.cl253.model.SendSmsRequest;

/**
 * 创蓝消息客户端
 * @author jayheo
 *
 */
public class ClMsgClient {
	

	private static Logger logger = LogManager.getLogger(ClMsgClient.class);
	
	private static final String  clServer = "http://smssh1.253.com";
	
	/**
	 * 发送消息
	 * @param account
	 * @param passwd
	 * @param smsRequest
	 * @return
	 */
	public static String send(String account ,String passwd,SendSmsRequest smsRequest){
		AssertUtil.assertMethodRequire(smsRequest, "smsRequest");
		AssertUtil.assertMethodRequire(account, "account");
		AssertUtil.assertMethodRequire(passwd, "passwd");
		String namespace = "/msg/send/json";
		
		SendSmsCommRequest commReq = smsRequest.createCommReq();
		commReq.setAccount(account);
		commReq.setPasswd(passwd);
		commReq.setRequireNotice(true);
		String traceId = DateUtil.toMilSecondsNumeric(new Date()) +  RandomStringUtils.randomNumeric(15);
		commReq.setTraceId(traceId);
		commReq.setSendDate(DateFormatUtils.format(new Date(), "yyyyMMddHHmm"));
		String commReqBody = GsonUtil.buildMilliSecondDateGson().toJson(commReq);
		logger.info("生成了短信跟踪id:[{}]",traceId);
		String respBody = SimpleHttpUtil.simplePost(clServer + namespace, commReqBody);
		SendSmsCommResponse resp = GsonUtil.buildMilliSecondDateGson().fromJson(respBody, SendSmsCommResponse.class);
		resp.handleResp();
		return traceId;
	}
	
	public static void batchCommandSend(String account ,String passwd,List<String> commands){
		batchSend(account, passwd, commands.stream().map(command->SendSmsRequest.fromCommand(command)).collect(Collectors.toList()).toArray(new SendSmsRequest[]{}));
	}
	
	public static void batchSend(String account ,String passwd,SendSmsRequest... smsRequests){
		for (SendSmsRequest smsRequest : smsRequests) {
			send(account, passwd, smsRequest);
		}
	}
	
	

}
