package com.mini.framework.third.cl253.comm;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.exception.ThirdException;

/**
 * 基础的响应
 * @author jayheo
 *
 */
public class Cl253AbstractResponse {
	
	
	private Logger logger = LogManager.getLogger(Cl253AbstractResponse.class);

	@SerializedName("time")
	private String date;

	@SerializedName("msgId")
	private String messageId;

	@SerializedName("errorMsg")
	private String errorMsg;

	@SerializedName("code")
	private Integer code;

	
	public void handleResp(){
		logger.info(String.format("收到创蓝响应:%s",this));
		if(code==null){
			throw new ThirdException("在解析消息的时候出错");
		}else if(0 ==code){
			//成功了
		}else{
			throw new ThirdException("在发送短信息时出现错误:%s,code:%s",errorMsg, code);
		}
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	
/*
  {"time":"20170410103836",
"msgId":"17041010383624511",
"errorMsg":"",
"code":"0"
}
 * 
 * */
}
