package com.mini.framework.third.kuaidi100.model;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.express.model.ExpressTransportStage;
import com.mini.framework.third.express.model.ExpressTransportStatus;
import com.mini.framework.third.express.model.ExpressTransportStatusItem;
import com.mini.framework.util.function.PredicateSpread;

public class ExpressStatusResponse extends AbstractResponse {

	/**
	 * 快递单当前状态，包括0在途，1揽收，2疑难，3签收，4退签，5派件，6退回，7转投 等7个状态
	 */
	private Integer state;

	/**
	 * ischeck	integer	0	是否签收标记
	 */
	@SerializedName("ischeck")
	private Integer recept;

	/**
	 * com	String	必须	ems	查询的快递公司的编码，一律用小写字母
	 */
	@SerializedName("com")
	private String company;

	@SerializedName("nu")
	private String number;

	@SerializedName("data")
	private List<StatusItem> stateItems;

	public Integer getState() {
		return state;
	}


	public void setState(Integer state) {
		this.state = state;
	}

	public Integer getRecept() {
		return recept;
	}

	public void setRecept(Integer recept) {
		this.recept = recept;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}

	public List<StatusItem> getStateItems() {
		return stateItems;
	}

	public void setStateItems(List<StatusItem> stateItems) {
		this.stateItems = stateItems;
	}

	public static ExpressStatusResponse fromJson(String json) {
		return fromJson(ExpressStatusResponse.class, json);
	}
	
	public ExpressTransportStatus mapperExpressTransportStatus(){
		ExpressTransportStatus transportStatus = new ExpressTransportStatus();
		transportStatus.setOriginalBody(getRespOriginal());
		transportStatus.setNumber(number);
		transportStatus.setOperateMarketCode(company);
		if(state!=null){
			transportStatus.setCurrStatus(ExpressTransportStage.fromKuaidi100Code(state).orElse(null));
		}
		if(stateItems!=null){
			List<ExpressTransportStatusItem> items = stateItems.stream().map(StatusItem::mapperExpressTransport)
					.sorted(Comparator.comparing(ExpressTransportStatusItem::getDate)).collect(Collectors.toList());
			//把第一个弄成 已揽件
			items.stream().findFirst().ifPresent(item->item.setStage(ExpressTransportStage.activation));
			transportStatus.setItems(items);
			items.stream().filter(PredicateSpread.of(ExpressTransportStatusItem::hasStage).negate()).forEach(item->item.setStage(ExpressTransportStage.progress));
			transportStatus.setCurrDate(transportStatus.lastItemDate().orElse(null));
		}
		return transportStatus ;
	}
	

}
