package com.mini.framework.third.kuaidi100.model;

import java.util.List;


import java.util.stream.Collectors;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.resource.ResourceUtil;

public class Kuaidi100Organization {

	private String version;

	private String code;

	private String name;

	private String logo;


	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Kuaidi100Organization(String version, String code, String name, String logo) {
		super();
		this.version = version;
		this.code = code;
		this.name = name;
		this.logo = logo;
	}

	public Kuaidi100Organization() {
		super();
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	public boolean matchCode(String code){
		return this.code!=null && this.code.equals(code);
	}
	
	
	/**
	 * 显示所有的公司
	 * @return
	 */
	public static List<Kuaidi100Organization> showOrganizationList(){
		String classpath = "/com/mini/framework/third/kuaidi100/kuaidi100.20190917102511.txt";
		String version = "20190917102511";
		List<String> lines = ResourceUtil.readLines(classpath);
		
		return lines.stream().map(line->{
			String[] items = line.split("\t");
			AssertUtil.assertNotFatal(items.length==2, "line:[%s]以\t切割后长度应该为2", line);
			return new Kuaidi100Organization(version, items[1], items[0], null);
		}).collect(Collectors.toList());
		//TODO 做适当的检查比较code排除重复
	}
}
