package com.mini.framework.third.kuaidi100.model;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.express.model.ExpressTransportStatus;

/**
 * 快递状态的推送的
 * 
 * @author jayheo
 *
 */
public class StatusPollResponse extends AbstractResponse{

	private String autoCheck;

	private String comOld;

	private String comNew;
	
	private String billstatus;

	@SerializedName("lastResult")
	private ExpressStatusResponse expressStatus;

	@SerializedName("destResult")
	private ExpressStatusResponse internationalExpressStatus;


	public String getBillstatus() {
		return billstatus;
	}

	public void setBillstatus(String billstatus) {
		this.billstatus = billstatus;
	}

	public String getAutoCheck() {
		return autoCheck;
	}

	public void setAutoCheck(String autoCheck) {
		this.autoCheck = autoCheck;
	}

	public String getComOld() {
		return comOld;
	}

	public void setComOld(String comOld) {
		this.comOld = comOld;
	}

	public String getComNew() {
		return comNew;
	}

	public void setComNew(String comNew) {
		this.comNew = comNew;
	}

	public ExpressStatusResponse getExpressStatus() {
		return expressStatus;
	}

	public void setExpressStatus(ExpressStatusResponse expressStatus) {
		this.expressStatus = expressStatus;
	}

	public ExpressStatusResponse getInternationalExpressStatus() {
		return internationalExpressStatus;
	}

	public void setInternationalExpressStatus(ExpressStatusResponse internationalExpressStatus) {
		this.internationalExpressStatus = internationalExpressStatus;
	}

	public static StatusPollResponse fromJson(String json) {
		return fromJson(StatusPollResponse.class, json);
	}
	
	public ExpressTransportStatus mapperExpressTransportStatus(){
		return expressStatus.mapperExpressTransportStatus();
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
