package com.mini.framework.third.lizhi.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.lizhi.model.TicketDto;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.RegexUtil;



/**
 * 读取ticket的工具
 * @author jayheo
 *TODO 如果名字中出现,csv在文本中会以""把名字包住，在excel中也能显示正常，但是当做 文档解析的时候就要注意了例如<br>
 *优惠码:95354243,2.0,不限期,专栏优惠券,"哥,,张佳龙",已使用,2019-11-16 13:59:42.287785,https://share.lizhiweike.com/channel2/381017?discount_code=95354243&y=1
 */
public class TicketFactory {

	//private static String ticketRegex = "([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),(http[^,]*)";
	private static String ticketRegex = "([^,]*):([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),(http[^,]*)";

	//private static String[] fileCharsets = {"GBK","ISO_8859_1","UTF_8","US_ASCII"};
	private static String[] fileCharsets = {"ISO_8859_1","UTF-8","US-ASCII","GBK"};
	
	private static String[] rightFlag = {"码","优惠","金","用"};
	
	private static String channelPattern = "https://[^/]*weike[^/]*/channel[^/]*/(\\d+)?";
	
	private static Logger logger = LogManager.getLogger(TicketFactory.class);
	
/**
 * <pre>
 * 优惠券代码,优惠券金额,有效期,适用范围,用户,状态,领取时间,领取链接
优惠码:95589997,2.0,不限期,专栏优惠券,飞帅,已使用,2018-09-29 21:57:17.907047,https://m.lizhiweike.com/channel/321918?discount_code=95589997&y=1
优惠码:95587370,2.0,不限期,专栏优惠券,未领取,可用,,https://m.lizhiweike.com/channel/321918?discount_code=95587370&y=1</pre>
 * */
	public static TicketDto  readFromString(String line){
		TicketDto ticket = new TicketDto();
		ticket.setLine(line);
		//TODO 要解析出packageKey
		String[] matchs = RegexUtil.getMatch(ticketRegex, line,new int[]{2,3,6,8,9});
		if(matchs!=null){
			ticket.setNumber(matchs[0]);
			try{
				ticket.setPrice(Double.parseDouble(matchs[1]));
			}catch(NumberFormatException e){
				throw new BadReqException("无法解析价格:[%s],行数据:[%s]",matchs[1], line);
			}
			ticket.setUseName(matchs[2]);
			//TODO 这里要把使用时间解析出现
			ticket.setUserDate(null);
			String accessUrl = matchs[4];
			ticket.setAccessUrl(accessUrl);
			ticket.setTargetUrl(StringUtils.substringBefore(accessUrl, "?"));
			
			String channel =findChannelFromUrl( accessUrl);
			//TODO 这里应该断言channel是否存在
			ticket.setChannel(channel);
			
			//目前是第一个版本
			ticket.setVersion(1);
		}
		return ticket;
	}

	/*public static List<TicketDto> readFromString(byte[] fileBytes){
		ByteArrayInputStream bais = new ByteArrayInputStream(fileBytes);
		
	}*/
	
	
	/**
	 * 从url中找出渠道值
	 * @param accessUrl
	 * @return
	 */
	public static String findChannelFromUrl(String accessUrl){
		String channel = RegexUtil.getMatch(channelPattern, accessUrl, 1);
		return channel;
	}
	

	public static List<TicketDto> readFromString(File file){
		List<String> lines = readMatchFirstLines(file);
		return readFromString(lines);
	}
	
	public static boolean matchTicketFirst(String line){
		AssertUtil.assertMethodRequire(line, "line");
		return Stream.of(rightFlag).filter(flag->line.contains(flag)).count()>0;
	}
	

	/**
	 * 读取匹配首行的内容
	 * @param file
	 * @return
	 */
	public static List<String> readMatchFirstLines(File file){
		Exception ex = null;
		String charset = null;
		for (String fileCharset : fileCharsets) {
			List<String> result = null;
			try{
				result = FileUtils.readLines(file, fileCharset);
				List<String> tempResult = result;
				Optional<String> firstLineOptional = tempResult.stream().findFirst();
				if(firstLineOptional.isPresent()){
					String firstLine = firstLineOptional.get();
					result.subList(0, 1).clear();
					boolean match = matchTicketFirst(firstLine);
					Event5WBuilder event = Event5WBuilder.event(1, "readMatchFirstLines").who("文件:[%s]", file)
					.what("匹配荔枝规则").result("匹配状态为:[%s]", match)
					.how("通过字符编码:[%s]解析检查首行有没有关键字:[%s],首页内容是:[%s]",fileCharset, String.join(",", rightFlag),firstLine);
					logger.info(event);
					if(!match){
						continue;
					}
				}else{
					logger.debug("文件:[{}]中读取的内容长度为:0",file);
				}
			}catch(FileNotFoundException e){
				throw new HandleIOException(e, "读券内容时找不到文件");
			}catch(IOException e){
				charset = fileCharset;
				ex = e;
				continue;
			}
			return result;
		}
		if(ex!=null){
			throw new HandleIOException(ex, "用编码:[%s]读取字符串内容时出错",charset);
		}else{
			throw new BadReqException(Status.BadReq.illParam,"文件%s无法解析出正常的优惠券首行必须包含字样:[%s]的一部分",file,String.join(",", rightFlag));
		}
	}

	public static List<TicketDto> readFromString(List<String> lines) {
		List<TicketDto> tickets = lines.stream()
				.filter(line -> StringUtils.isNotBlank(line))
				.map(line  ->TicketFactory.readFromString(line)).collect(Collectors.toList());
		return tickets;
	}
	
	
	
}
