package com.mini.framework.third.resourse.article.block;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.resourse.article.block.model.ArticleRawContent;
import com.mini.framework.util.asserts.AssertUtil;

public class ReadArticleBlockHelper {

	private Map<String, ResourseAnalysis> analysises;
	
	public static ReadArticleBlockHelper simpleBuild(){
		ReadArticleBlockHelper ssh = new ReadArticleBlockHelper();
		ssh.analysises = buildSimpleAnalysises();
		return ssh;
	}
	
	public static Map<String, ResourseAnalysis> buildSimpleAnalysises(){
		Map<String, ResourseAnalysis> analysises = new LinkedHashMap<>();
		for (ResourseAnalysisType resourseAnalysisType : ResourseAnalysisType.values()) {
			try {
				analysises.put(resourseAnalysisType.name(),resourseAnalysisType.getAnalysisClass().newInstance());
			} catch (InstantiationException | IllegalAccessException e) {
				throw new BusyException(e,"在创建类%s的实例时报错", resourseAnalysisType.getAnalysisClass());
			}
		}
		return analysises;
	}
	
	public ArticleRawContent read(String url){
		Optional<ResourseAnalysis> analysis = analysises.entrySet().stream().map(Entry::getValue)
		.filter(ass->ass.urlResourseMatch(url)).findFirst();
		AssertUtil.assertNoBadReq(analysis.isPresent(), Status.BadReq.illParam, "系统暂时没有能解析:[%s]的工具类",url);
		//TODO 这里要检查一下空等东西
		return analysis.get().analysis(url);
	}
	
}
