package com.mini.framework.third.resourse.article.block.model;

import java.util.ArrayList;
import java.util.List;

/**
 * 文章内容
 */
public class ArticleRawContent {

    public void createContent(String tagName, String text) {
        this.createContent(tagName, text, null);
    }

    public void createContent(String type, String value, String suffix) {

        if (this.contents == null) {
            this.contents = new ArrayList<>();
        }

        this.contents.add(new Content(type, value, suffix));
    }


    public class Content {

        private String type;
        private String value;
        private String suffix;

        public Content(String type, String value, String suffix) {
            this.type = type;
            this.value = value;
            this.suffix = suffix;
        }

        public Content(String type, String value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getSuffix() {
            return suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }

    private String id;

    private String title;

    private String account;

    private List<Content> contents;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public List<Content> getContents() {
        return contents;
    }

    public void setContents(List<Content> contents) {
        this.contents = contents;
    }
}
