package com.mini.framework.third.weixin.auth;

import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.string.StringUtil;
import org.apache.commons.lang3.RandomStringUtils;


/**
 * 微信网页授权帮助类
 *
 * @author jayheo*/
public class WebAuthHelper {


    /**
     * 网页授权时默认的域名。
     * */
    public static final String webAuthDefaultHome = "open.weixin.qq.com";

    //TODO 目前那个微信代理性能不好，到时要统一优化一下。

    /**
     * 生成一个网页授权的地址
     * https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx8790b57def4ab529&redirect_uri=https%3A%2F%2Fwa1.aquke.com%2Fconnect%2Foauth2%2Fauthorize%3FoldReferer%3Dhttps%253A%252F%252Fys.aquke.com%252Flogin%252FwxEnd%253Frefer%253D%25252F&response_type=code&scope=snsapi_userinfo&state=3761736294&connect_redirect=1
     * */
    public static String createWebAuthUrl(String appid,boolean requireInfo,String backUrl){
        return createProxyWebAuthUrl(webAuthDefaultHome,appid, requireInfo, backUrl);
    }


    /**
     * 生成一个网页授权的地址
     * https://open.weixin.qq.com/connect/oauth2/authorize?appid=wx8790b57def4ab529&redirect_uri=https%3A%2F%2Fwa1.aquke.com%2Fconnect%2Foauth2%2Fauthorize%3FoldReferer%3Dhttps%253A%252F%252Fys.aquke.com%252Flogin%252FwxEnd%253Frefer%253D%25252F&response_type=code&scope=snsapi_userinfo&state=3761736294&connect_redirect=1
     * 参考文档
     * https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html
     * */
    public static String createProxyWebAuthUrl(String domain,String appid,boolean requireInfo,String backUrl){
        String webAuthApi = String.format("https://%s/connect/oauth2/authorize", domain);
        String marker = RandomStringUtils.randomNumeric(10);
        MapParams params = MapParams.build("appid",appid)
                .param("redirect_uri", StringUtil.urlEncode(backUrl))
                .param("state",marker)
                //TODO connect_redirect这个参数的特性还没有完全弄清楚，需要以后查阅资料处理好。
                .param("connect_redirect",1)
                .param("response_type","code")
                .param("scope",requireInfo?"snsapi_userinfo":"snsapi_base");
        String url = params.toUrlParams(webAuthApi);
        url += "#wechat_redirect";
        //TODO 断言中间不能出来 null
        return url;
    }

}
