package com.mini.framework.third.weixin.console.model;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.asserts.AssertUtil;

public class WeixinCurlCommandSectionable extends WeixinCurlCommand {

	public WeixinCurlCommandSectionable(String url, String cookie) {
		super(url, cookie);
	}

	private Integer offset;
	private Integer limit;
	private Integer length;
	
	

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	public Integer getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	public Integer getLength() {
		return length;
	}

	public void setLength(Integer length) {
		this.length = length;
	}
	
	public WeixinCurlCommandSectionable setSection(int offset,int limit){
		this.offset = offset;
		this.limit = limit;
		setUrlIntParam("begin", this.offset);
		setUrlIntParam("count", this.limit);
		return this;
	}
	
	public WeixinCurlCommandSectionable setSection(int offset,int limit,int length){
		setSection(offset, limit);
		this.length = length;
		return this;
	}
	
	public WeixinCurlCommandSectionable(){
		super(null, null);
	}
	
	public WeixinCurlCommandSectionable(WeixinCurlCommand command){
		this(command.getUrl(), command.getCookie());
	}
	
	public boolean nextSection(Integer count){
		AssertUtil.assertMethodRequire(count, "count");
		boolean haveNext = count > this.offset + limit;
		if(haveNext){
			//this.offset = Math.min(count, this.offset + length);
			this.offset =  this.offset + limit;
			this.limit = Math.min(count-offset, limit);
			setUrlIntParam("begin", this.offset);
			setUrlIntParam("count", this.limit);
		}
		return haveNext;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
