package com.mini.framework.third.weixin.console.server.model.template;

import java.util.List;
import java.util.function.Function;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.exception.standard.CustomException;

public class DocumentListResponse {
	
	
	@SerializedName("base_resp")
	private ResponseStatusBean status;

	@SerializedName("data")
	private String dataNodeString;

	private List<FirstIndustry> industrys;

	private List<Document> documents;

	private Integer documentCount;

	private DataNode dataNode;

	@SerializedName("tmpl_msg_attr_info")
	private CurrentMatchIndustry currentMatchIndustry;

	public static class DataNode {

		@SerializedName("class_info")
		private IndustryNode industryNode;
		@SerializedName("store_tmpl_info")
		private TemplateNode templateNode;

		public IndustryNode getIndustryNode() {
			return industryNode;
		}

		public void setIndustryNode(IndustryNode industryNode) {
			this.industryNode = industryNode;
		}

		public TemplateNode getTemplateNode() {
			return templateNode;
		}

		public void setTemplateNode(TemplateNode templateNode) {
			this.templateNode = templateNode;
		}

		public static class IndustryNode {
			@SerializedName("sub_class")
			private List<FirstIndustry> industrys;

			public List<FirstIndustry> getIndustrys() {
				return industrys;
			}

			public void setIndustrys(List<FirstIndustry> industrys) {
				this.industrys = industrys;
			}
		}

		public static class TemplateNode {
			@SerializedName("store_tmpl")
			private List<Document> documents;
			@SerializedName("total_count")
			private Integer documentCount;

			public Integer getDocumentCount() {
				return documentCount;
			}

			public void setDocumentCount(Integer documentCount) {
				this.documentCount = documentCount;
			}

			public List<Document> getDocuments() {
				return documents;
			}

			public void setDocuments(List<Document> documents) {
				this.documents = documents;
			}

		}

	}
	
	public <E extends CustomException>  void validateStatus(Function<String, E> exceptionSupplier) throws E{
		if(status==null){
			throw exceptionSupplier.apply(String.format("结果错误没有status节点key:[%s]", "base_resp"));
		}else if(!status.success()){
			throw exceptionSupplier.apply(String.format("请求错误msg:[%s],code:[%s]", status.getMsg(),status.getCode()));
		}
	}

	/**
	 * 加载数据
	 * @return
	 */
	public <E extends CustomException> DocumentListResponse loadData(Function<String, E> exceptionSupplier) throws E{
		validateStatus(exceptionSupplier);
		this.dataNode = new Gson().fromJson(dataNodeString, DataNode.class);
		if(this.dataNode!=null){
			this.documents = dataNode.templateNode.documents;
			this.industrys = dataNode.industryNode.industrys;
			this.documentCount = dataNode.templateNode.documentCount;
		}
		return this;
	}
	
	public ResponseStatusBean getStatus() {
		return status;
	}

	public void setStatus(ResponseStatusBean status) {
		this.status = status;
	}

	public String getDataNodeString() {
		return dataNodeString;
	}

	public void setDataNodeString(String dataNodeString) {
		this.dataNodeString = dataNodeString;
	}

	public List<FirstIndustry> getIndustrys() {
		return industrys;
	}

	public void setIndustrys(List<FirstIndustry> industrys) {
		this.industrys = industrys;
	}

	public List<Document> getDocuments() {
		return documents;
	}

	public void setDocuments(List<Document> documents) {
		this.documents = documents;
	}

	public Integer getDocumentCount() {
		return documentCount;
	}

	public void setDocumentCount(Integer documentCount) {
		this.documentCount = documentCount;
	}

	public DataNode getDataNode() {
		return dataNode;
	}

	public void setDataNode(DataNode dataNode) {
		this.dataNode = dataNode;
	}
	
	public CurrentMatchIndustry getCurrentMatchIndustry() {
		return currentMatchIndustry;
	}

	public void setCurrentMatchIndustry(CurrentMatchIndustry currentMatchIndustry) {
		this.currentMatchIndustry = currentMatchIndustry;
	}
	
	public static DocumentListResponse fromJson(String json){
		return new Gson().fromJson(json, DocumentListResponse.class);
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
