package com.mini.framework.third.weixin.mapp;

import com.mini.framework.third.weixin.mapp.model.MappCodePhotoRequest;
import com.mini.framework.third.weixin.mapp.model.WeixinMappConstant;
import com.mini.framework.util.oss.OssHelper;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.params.MapParams;

public class WeixinMappAwakeSupport {

	/**
	 * 创建唤醒命令的小程序码
	 * @param weixinMappSdk
	 * @param token
	 * @param params
	 * @param ossHelper
	 * @return
	 */
	public static String createCommandAwakeMappQrcode(WeixinMappSdk weixinMappSdk,String token,MapParams params,OssHelper ossHelper){
		return createMappQrcode(WeixinMappConstant.commandAwake01Pages,weixinMappSdk, token, params, ossHelper);
	}
	
	
	public static String createMappQrcode(String page,WeixinMappSdk weixinMappSdk,String token,MapParams params,OssHelper ossHelper){
		MappCodePhotoRequest req = new MappCodePhotoRequest();
		req.setPage(page);
		String scene = params.toUrlParams();;
		req.setScene(scene);//通过推荐码可以得到用户，通过用户就知道哪个名片了
		req.setHyaline(false);
		req.setAuthColor(false);
		req.setLineColor(0, 0, 0);//TODO 颜色是待处理的
		//TODO 对于小程序的海报能不能拼成一个普通海报加下面的白底
		byte[] bytes = weixinMappSdk.createMappQrcode(token ,req );
		String path = ossHelper.upload(bytes, "png");
		//把小程序码切成半径为100的原形，改成png以方便后面的透明
		//如图，https://aqukedev.oss-cn-shanghai.aliyuncs.com/file/7/201903/24/20190324143603714344020.png
		//微信算出来的小程序图片的尺寸430*430
		path = OssImageProcessParams.circleByRadius(path,215);
		path = ossHelper.uploadResWithHost(ossHelper.assemServerHome(path));
		//TODO 生成微信小程序的二维码
		return path;
	}
	
	
	public static String mappPath(){
		//MapParams.build(paramKey, paramValue);
		
		
		
		
		
		
		return null;
	}
	
}
