package com.mini.framework.third.weixin.mapp.model;

import java.util.Date;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

public class AccessTokenResponse extends AbstractResponse{
	@SerializedName("access_token")
	private String token;

	@SerializedName("expires_in")
	private Integer expire;

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public Integer getExpire() {
		return expire;
	}

	public void setExpire(Integer expire) {
		this.expire = expire;
	}
	
	public Date tokenExpireDate(){
		AssertUtil.simpleAssertByStatus(expire!=null, Status.Third.wxRespForm, "微信的响应格式错误");
		Date tokenExpire = new Date(System.currentTimeMillis() + expire*1000);
		return tokenExpire;
	}
}
