package com.mini.framework.third.weixin.mapp.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;

/*
{
    "openId": "obCMK4zJqxFPQg98Ai4hz0dLhuiI",
    "nickName": "5. 1",
    "gender": 1,
    "language": "zh_CN",
    "city": "Changsha",
    "province": "Hunan",
    "country": "China",
    "avatarUrl": "https://wx.qlogo.cn/mmopen/vi_32/QwDYdia2ib07CL7aBf6w0AAqChsDJVJGiaViblMkd9l6fGgDhDdIIDySsxkVq5f5YvJdlgI0qOll7Unl58fNZnAjyg/132",
    "unionId": "oeuhI6GEgwpUwZ6k6Zwcx3mEnTMA",
    "watermark": {
        "timestamp": 1548833055,
        "appid": "wx3bbb5037acaa50f1"
    }
}
*/
/**
 * 小程序用户信息
 * @author jayheo
 *
 */
public class MappUserInfoResponse {
	@SerializedName(value="openid",alternate="openId")
	private String openId;
	@SerializedName("nickName")
	private String nick;
	@SerializedName("gender")
	private Integer sex;
	@SerializedName("province")
	private String province;
	@SerializedName("city")
	private String city;
	@SerializedName("country")
	private String country;
	@SerializedName("avatarUrl")
	private String headIco;
	@SerializedName(value="unionid",alternate="unionId")
	private String unionid;
	/**
	 * 标记来源是不是加密数据里的
	 */
	private boolean crypt;
	
	public String getOpenId() {
		return openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}
	public String getNick() {
		return nick;
	}
	public void setNick(String nick) {
		this.nick = nick;
	}
	public Integer getSex() {
		return sex;
	}
	public void setSex(Integer sex) {
		this.sex = sex;
	}
	public String getProvince() {
		return province;
	}
	public void setProvince(String province) {
		this.province = province;
	}
	public String getCity() {
		return city;
	}
	public void setCity(String city) {
		this.city = city;
	}
	public String getCountry() {
		return country;
	}
	public void setCountry(String country) {
		this.country = country;
	}
	public String getHeadIco() {
		return headIco;
	}
	public void setHeadIco(String headIco) {
		this.headIco = headIco;
	}
	public String getUnionid() {
		return unionid;
	}
	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}
	
	public boolean isCrypt() {
		return crypt;
	}
	public void setCrypt(boolean crypt) {
		this.crypt = crypt;
	}
	/**
	 * 组装签名
	 * @return
	 */
	public String assemSign(){
		String type;
		if(sex==null){
			type = "网友";
		}else if(sex==1){
			type = "小哥哥";
		}else if(sex==2){
			type = "小姐姐";
		}else{
			type = "网友";
		}
		return String.format("我是来自%s，%s省，%s市的%s" , getCountry() ,getProvince() , getCity(),type);
	}
	
	/**
	 * 显示加密的openid如果没有就显示传入openid
	 * @param openid
	 * @return
	 */
	public String showCryptOpenId(String openid){
		if(isCrypt()){
			return this.openId;
		}else{
			return openid;
		}
	}
	
	
	public WeixinServerUserDetail mapServerUserDetail(){
		WeixinServerUserDetail userDetail = new WeixinServerUserDetail();
		userDetail.setCity(this.city);
		userDetail.setCountry(this.country);
		userDetail.setNick(this.nick);
		userDetail.setOpenId(this.openId);
		userDetail.setProvince(province);
		userDetail.setSex(sex);
		userDetail.setUnionId(unionid);
		return userDetail;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.DEFAULT_STYLE);
	}
}
