package com.mini.framework.third.weixin.mapp.model.bean;

import com.mini.framework.util.string.gson.builder.GsonData;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscribeMessageParam {

    private String name;
    private String value;

    public static Map<String,Object> parseAsMap(List<SubscribeMessageParam> params){
        Map<String, Object> map = new HashMap<>();
        params.forEach(param->{
            Map<String,String> target = new HashMap<>();
            target.put("value",param.value);
           map.put(param.name,target);
        });
        return map;
    }
    
    public void fillDataOfBody(GsonData data){
        data.object(name, param->param.param("value", value));
    }

    public static void fillBody(GsonData body,List<SubscribeMessageParam> params){
        body.object("data", data-> params.forEach(param->param.fillDataOfBody(data)));
    }
    
    

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
