package com.mini.framework.third.weixin.notice.server.geteway;


import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;

import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.third.weixin.notice.server.handler.WeixinServerNoticeHandler;
import com.mini.framework.third.weixin.notice.server.model.WeixinNoticeType;
import com.mini.framework.third.weixin.notice.server.model.WeixinOpenidSureResult;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinAskMsg;
import com.mini.framework.third.weixin.notice.server.model.resp.WeixinNotice;
import com.mini.framework.third.weixin.notice.server.util.WeixinNoticeMsgFactory;

public abstract class AbstractWeixinNoticeController {
	
	private Logger logger = LogManager.getLogger(AbstractWeixinNoticeController.class);
	
	protected abstract WeixinServerNoticeHandler getWeixinServerNoticeHandler();
	
	/**
	 * 确认openid
	 * @param weixinNoticeType 
	 * @param appid
	 * @param openid
	 * @return
	 */
	protected abstract WeixinOpenidSureResult handleWeixinOpenid(WeixinNoticeType weixinNoticeType, String appid,String openid)  ;
	
	/**
	 * 处理微信帐号，返回微信appid
	 * @param account
	 */
	protected abstract String handleWeixinAccount(String account) ;
	
	/**
	 * 测试示例
	 * url http://api.study.dev.aquke.com/third/push/weixin
	 * token:d4v0984h835465
	 * /third/push/weixin
	 * ?signature=1302fdfd636505e019d12ef612ae7121f7f75afa
	 * &echostr=6879712636695462781
	 * &timestamp=1518273033
	 * &nonce=3507012660
	 * */
	//TODO https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1434696670
	//@PostMapping("/weixin/push")
	//@ResponseBody
	public String handleReq(String signature,String echostr,String timestamp,String nonce ,@RequestBody String body) {
		Event5WBuilder event = Event5WBuilder.event(2, "weixinPush").what("推送body:%s", body).who("微信服务器");
		logger.debug(event);
		String account = WeixinNoticeMsgFactory.showAccount(body);
		String appid = this.handleWeixinAccount(account);
		String openid = WeixinNoticeMsgFactory.showOpenid(body);
		WeixinNotice weixinNotice = WeixinNoticeMsgFactory.readXmlNotice(body);
		if(weixinNotice.cancelSubscribe()){// 如果是不是取消登录
			logger.debug("当前微信事件:{}可以知晓用户已取消关注所以不去走登录流程",weixinNotice.getWeixinNoticeType());
		}else{
			WeixinOpenidSureResult sureOpenid = this.handleWeixinOpenid(weixinNotice.getWeixinNoticeType(),appid, openid);
			weixinNotice.setOpenidUser(sureOpenid);
		}
		//TODO getWeixinResponseUtil().checkSignature(Integer.parseInt(merchantId),signature, timestamp, nonce);
		weixinNotice.setAppid(appid);
		WeixinAskMsg ask = getWeixinServerNoticeHandler().handle(weixinNotice);
		//把响应数据转成xml字符串
		String response = ask.toAnswerWeixinResponse();
		Event5WBuilder retEvent = Event5WBuilder.event(1, "weixinPush").what("返回报文给微信:[%s]", response).who("服务端").why("正常处理完成");
		logger.log(MiniLogLevel.getKeyBizLog(),retEvent);
		return response;
	}
}
