package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140453
<xml><ToUserName>< ![CDATA[toUser] ]></ToUserName><FromUserName>< ![CDATA[fromUser] ]></FromUserName><CreateTime>1357290913</CreateTime><MsgType>< ![CDATA[voice] ]></MsgType><MediaId>< ![CDATA[media_id] ]></MediaId><Format>< ![CDATA[Format] ]></Format><MsgId>1234567890123456</MsgId></xml>
参数	描述
ToUserName	开发者微信号
FromUserName	发送方帐号（一个OpenID）
CreateTime	消息创建时间 （整型）
MsgType	语音为voice
MediaId	语音消息媒体id，可以调用多媒体文件下载接口拉取数据。
Format	语音格式，如amr，speex等
MsgID	消息id，64位整型

请注意，开通语音识别后，用户每次发送语音给公众号时，微信会在推送的语音消息XML数据包中，增加一个Recongnition字段（注：由于客户端缓存，开发者开启或者关闭语音识别功能，对新关注者立刻生效，对已关注用户需要24小时生效。开发者可以重新关注此帐号进行测试）。开启语音识别后的语音XML数据包如下：
<xml><ToUserName>< ![CDATA[toUser] ]></ToUserName><FromUserName>< ![CDATA[fromUser] ]></FromUserName><CreateTime>1357290913</CreateTime><MsgType>< ![CDATA[voice] ]></MsgType><MediaId>< ![CDATA[media_id] ]></MediaId><Format>< ![CDATA[Format] ]></Format><Recognition>< ![CDATA[腾讯微信团队] ]></Recognition><MsgId>1234567890123456</MsgId></xml>
*/
/**
 * 微信语音的通知
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class VoiceNotice extends WeixinNotice{
	@XStreamAlias("Format")
	private String format;
	
	@XStreamAlias("MediaId")
	private String mediaId;
	
	/**
	 * 语音被 翻译过来的文本
	 */
	@XStreamAlias("Recognition")
	private String tranText;


	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getMediaId() {
		return mediaId;
	}

	public void setMediaId(String mediaId) {
		this.mediaId = mediaId;
	}
	
	

	public String getTranText() {
		return tranText;
	}

	public void setTranText(String tranText) {
		this.tranText = tranText;
	}

}
