package com.mini.framework.third.weixin.pay;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

import javax.net.ssl.SSLContext;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContexts;

import com.mini.framework.core.exception.HandleException;

/**
 * 支付证书工具
 * @author jayheo
 *
 */
public class PayCertUtil {

	
	public static SSLContext loadCertFactoryQuiet(InputStream certInputStream,String certSecret){
		try {
			return loadCertFactory(certInputStream, certSecret);
		} catch (KeyManagementException | UnrecoverableKeyException | KeyStoreException | NoSuchAlgorithmException
				| CertificateException | IOException e) {
			throw new HandleException(e,"读取证书的时候出错");
		}
	}
	
	public static SSLContext loadCertFactory(InputStream certInputStream,String certSecret)
			throws KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException{
        KeyStore keyStore  = KeyStore.getInstance("PKCS12");
        char[] certSecretChars = certSecret.toCharArray();
       // FileInputStream instream = new FileInputStream(new File("O:/xzh/cert/wxpay/1555371381/1555371381_20191202_cert/apiclient_cert.p12"));
				keyStore.load(certInputStream, certSecretChars);

        // Trust own CA and all self-signed certs
        SSLContext sslcontext = SSLContexts.custom()
                .loadKeyMaterial(keyStore, certSecretChars)
                .build();
        return sslcontext;
        // Allow TLSv1 protocol only
/*        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
                sslcontext,
                new String[] { "TLSv1" },null,
                SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        return sslsf;*/
	}
	
}
