package com.mini.framework.third.weixin.pay;

import java.io.ByteArrayInputStream;

import javax.net.ssl.SSLContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.paas.MultiSiteConfig;
import com.mini.framework.util.string.XStreamUtil;
import com.mini.framework.core.status.Status;
import com.mini.framework.third.weixin.pay.client.MappJsPayResponse;
import com.mini.framework.third.weixin.pay.client.MappPrePayRequest;
import com.mini.framework.third.weixin.pay.client.MappPrePayResponse;
import com.mini.framework.third.weixin.pay.client.PayApiClient;
import com.mini.framework.third.weixin.pay.client.PublicJsPayResponse;
import com.mini.framework.third.weixin.pay.client.PublicPrePayRequest;
import com.mini.framework.third.weixin.pay.client.PublicPrePayResponse;
import com.mini.framework.third.weixin.pay.client.PublicRefundApplyRequest;
import com.mini.framework.third.weixin.pay.client.PublicRefundApplyResponse;
import com.mini.framework.third.weixin.pay.client.QueryOrderRequest;
import com.mini.framework.third.weixin.pay.client.QueryOrderResponse;
import com.mini.framework.third.weixin.pay.model.UserMappPayRequest;
import com.mini.framework.third.weixin.pay.model.UserMappPayResponse;
import com.mini.framework.third.weixin.pay.model.UserPublicPayRequest;
import com.mini.framework.third.weixin.pay.model.UserPublicPayResponse;
import com.mini.framework.third.weixin.pay.model.UserPublicRefundApplyRequest;
import com.mini.framework.third.weixin.pay.model.UserPublicRefundApplyResponse;
import com.mini.framework.third.weixin.pay.model.WxMappPayConfig;
import com.mini.framework.third.weixin.pay.model.WxPublicPayConfig;

/**
 * 服务号支付
 * @author jayheo
 *
 */
public class WinxinPayHelper<S> {

	Logger logger = LogManager.getLogger(WinxinPayHelper.class);

	/**
	 * 商家配置
	 */
	private MultiSiteConfig<S, WxPublicPayConfig> siteH5PayConfig;

	private MultiSiteConfig<S, WxMappPayConfig> siteMappPayConfig;


	public WinxinPayHelper(MultiSiteConfig<S, WxPublicPayConfig> siteH5PayConfig) {
		super();
		this.siteH5PayConfig = siteH5PayConfig;
	}


	public WinxinPayHelper(MultiSiteConfig<S, WxPublicPayConfig> siteH5PayConfig,MultiSiteConfig<S, WxMappPayConfig> siteMappPayConfig) {
		super();
		this.siteH5PayConfig = siteH5PayConfig;
		this.siteMappPayConfig = siteMappPayConfig;
	}


	/**
	 * 这个方法会根据线程中的商家去取配置，但是目前一个商家可以有多个配置所以这个方法已废弃
	 * @see #publicPrePay(UserPublicPayRequest, WxPublicPayConfig)
	 */
	@Deprecated
	public UserPublicPayResponse publicPrePay(UserPublicPayRequest request) {
		AssertUtil.assertNotFatalProgramConfig(siteH5PayConfig!=null, Status.Server.programConfigJava,"没有配置服务号支付的商家配置");
		WxPublicPayConfig config = siteH5PayConfig.currBean();
		return publicPrePay(request, config);
	}
	
	/*
响应报文验证签名的重要性。
1，我拦截了请求支付请求，你以为你请求到了微信实际请求到了我。
2，我用我自己的商户弄一个支付的响应，你拿到响应后(没有验证证，以为是微信给你的)
3，你拿着这个被伪造的响应给前台。
4，前台支付成功。
5，我的商户收到钱了，你没有收到。
当然你也不会收到收款成功的通知，只会我收到，但是用户是付款了。

财付通对接了很多银行，基本都双向通讯签名验证这么玩的，这是最基础的玩法，还有很多高级的玩法。
对方要确认报文是你发的，同时你也要确认报文不会被伪造的。
	 * */
	/**
	 * 支付的第一步
	 * @param payRequest
	 * @return
	 */
	public static UserPublicPayResponse publicPrePay(UserPublicPayRequest request,WxPublicPayConfig config) {
		AssertUtil.assertMethodRequire(request, "request");
		AssertUtil.assertMethodRequire(config, "config");
		PublicPrePayRequest connRequest = new PublicPrePayRequest(request);
		connRequest.fillConfig(config);
		connRequest.setNotifyUrl(config.getNotifyUrl());
		connRequest.sign(config.getMchKey());
		//30分钟内要付款完。TODO 不知道为什么，生成后签名失败需要检查一下问题。
		//connRequest.setExpireDate(DateUtil.toSecondsNumeric(new Date(System.currentTimeMillis() +30 * 60 * 1000)));
		PublicPrePayResponse connresponse = PayApiClient.publicPay(connRequest);

		//TODO 考虑到返回的参数太多 又难出现 安全问题，打算不验证签名了。
		//connresponse.verify(config.getMchKey());

        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000);
        String packAge = "prepay_id=" + connresponse.getPrepayId();
        UserPublicPayResponse response = new UserPublicPayResponse();
        response.setAppId(connresponse.getAppid());
        response.setTimeStamp(timeStamp);
        response.setPackAge(packAge);
		response.sign(config.getMchKey());
		//https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=7_7&index=6
		//商家这边生成的支付id 签名有问题过不了。所以下面的不算到签名里。文档中只有6个字段算到签名里面
		response.setOutTradeNo(request.getOrderId());
        response.setMwebUrl(connresponse.getMwebUrl());
        return response;
    }
	
	

	/*
	 *
	 * https://pay.weixin.qq.com/wiki/doc/api/micropay.php?chapter=9_4
	 * 当交易发生之后一段时间内，由于买家或者卖家的原因需要退款时，卖家可以通过退款接口将支付款退还给买家，微信支付将在收到退款请求并且验证成功之后，按照退款规则将支付款按原路退到买家帐号上。

注意：

1、交易时间超过一年的订单无法提交退款

2、微信支付退款支持单笔交易分多次退款，多次退款需要提交原支付订单的商户订单号和设置不同的退款单号。申请退款总金额不能超过订单金额。 一笔退款失败后重新提交，请不要更换退款单号，请使用原商户退款单号

3、请求频率限制：150qps，即每秒钟正常的申请退款请求次数不超过150次

    错误或无效请求频率限制：6qps，即每秒钟异常或错误的退款申请请求不超过6次

4、每个支付订单的部分退款次数不能超过50次
*/
	
	/*
	 * TODO 这里可不可抛出几个异常， 退款失败的原因，用于上层作后续处理
	 * msg :公众号支付业务错误code:INVALID_REQUEST,msg:refund_fee大于可退金额
	 * 订单已全额退款
	 * */
	
	/** 
	 *  TODO 以后计划在这里抛出几个异常
	 * 公众号的支付申请退款
	 * @param siteOrderNo 商家这边订单号
	 */
	public static UserPublicRefundApplyResponse publicApplyRefund(UserPublicRefundApplyRequest request,WxPublicPayConfig config){
		AssertUtil.assertMethodRequire(request, "request");
		AssertUtil.assertMethodRequire(config, "config");
		PublicRefundApplyRequest connRequest = new PublicRefundApplyRequest();
		connRequest.fillConfig(config);
		//TODO 支付和退款的通知地址现在是一样会不会出问题，要做判断
		//connRequest.setNotifyUrl(config.getNotifyUrl()); 暂时不走通知
		connRequest.setTotalFee(request.getTotalMoney());
		connRequest.setRefundFee(request.getRefundMoney());
		connRequest.setOutTradeNo(request.getSitePayOrderNo());
		connRequest.setOutRefundNo(request.getSiteRefundNo());
		connRequest.sign(config.getMchKey());
		
		AssertUtil.assertNoBadReq(config.getCertSecret()!=null, Status.BadReq.noReq, "证书的密码不能为空");
		AssertUtil.assertNoBadReq(config.getMchCert()!=null, Status.BadReq.noReq, "证书不能为空");
		SSLContext sslContext = PayCertUtil.loadCertFactoryQuiet(new ByteArrayInputStream(config.getMchCert()), config.getCertSecret());
		PublicRefundApplyResponse connResponse = PayApiClient.publicRefundApply(sslContext , connRequest);
		UserPublicRefundApplyResponse response = new UserPublicRefundApplyResponse();
        response.setAppId(connResponse.getAppid());
        response.setWeixinRefundOrderNo(connResponse.getWeixinRefundNo());
		return response ;
	}

	/**
	 * 小程序预支付,此方法已经废弃
	 * @see #mappPrePay(UserMappPayRequest, WxMappPayConfig) 
	 * @param request
	 * @return
	 */
	@Deprecated
	public UserMappPayResponse mappPrePay(UserMappPayRequest request) {
		WxMappPayConfig config = siteMappPayConfig.currBean();
		return mappPrePay(request,config);
	}

	/**
	 * 小程序预支付
	 * @param request
	 * @return
	 */
	public static UserMappPayResponse mappPrePay(UserMappPayRequest request,WxMappPayConfig config) {
		MappPrePayRequest connRequest = new MappPrePayRequest(request);
		connRequest.fillConfig(config);
		connRequest.setNotifyUrl(config.getNotifyUrl());
		connRequest.sign(config.getMchKey());
		//30分钟内要付款完。TODO 不知道为什么，生成后签名失败需要检查一下问题。
		//connRequest.setExpireDate(DateUtil.toSecondsNumeric(new Date(System.currentTimeMillis() +30 * 60 * 1000)));
		MappPrePayResponse connresponse = PayApiClient.mappPay(connRequest);

		//TODO 考虑到返回的参数太多 又难出现 安全问题，打算不验证签名了。
		//connresponse.verify(config.getMchKey());

        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000);
        String packAge = "prepay_id=" + connresponse.getPrepayId();
        UserMappPayResponse response = new UserMappPayResponse();
        response.setAppId(connresponse.getAppid());
        response.setTimeStamp(timeStamp);
        response.setPackAge(packAge);
		response.sign(config.getMchKey());
		//https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=7_7&index=6
		//商家这边生成的支付id 签名有问题过不了。所以下面的不算到签名里。文档中只有6个字段算到签名里面
		response.setOutTradeNo(request.getOrderId());
        response.setMwebUrl(connresponse.getMwebUrl());
        return response;
    }




	/**
	 * 小程序支付状态查询
	 * @return
	 */
	public String mappPayStatus(String sitePayOrder){
		WxMappPayConfig config = siteMappPayConfig.currBean();
		QueryOrderRequest connRequest = new QueryOrderRequest();
		connRequest.fillConfig(config);
		connRequest.setSitePayOrder(sitePayOrder);
		connRequest.sign(config.getMchKey());
		QueryOrderResponse connResponse = PayApiClient.queryOrder(connRequest);
		return connResponse.getTradeState();
	}



	/**
	 * 服务号支付状态查询
	 * @param sitePayOrder
	 * @return
	 */
	public String publicPayStatus(String sitePayOrder){
		WxPublicPayConfig config = siteH5PayConfig.currBean();
		return serverPayStatus(sitePayOrder, config);
	}


	/**
	 * 服务号支付状态查询
	 * @return
	 */
	public static String serverPayStatus(String sitePayOrder,WxPublicPayConfig config){
		return publicJsapiPayStatus(sitePayOrder, config).getTradeState();
	}
	
	
	/**
	 * 公众号 jsapi 支付结果查询
	 * @param sitePayOrder
	 * @param config
	 * @return
	 */
	public static QueryOrderResponse publicJsapiPayStatus(String sitePayOrder,WxPublicPayConfig config){
		QueryOrderRequest connRequest = new QueryOrderRequest();
		connRequest.fillConfig(config);
		connRequest.setSitePayOrder(sitePayOrder);
		connRequest.sign(config.getMchKey());
		QueryOrderResponse connResponse = PayApiClient.queryOrder(connRequest);
		return connResponse;
	}
	

	/**
	 * 解析js支付通知报文
	 *TODO 目前，只是拿到订单没有直接信任，而以去查单 所以没有使用验签功能，所以忽略掉了很多字段。
	 * @param noticeResp
	 * @return
	 */
	public static PublicJsPayResponse publicJsPayNotice(String noticeResp){
		PublicJsPayResponse resp = XStreamUtil.fromXml(noticeResp, PublicJsPayResponse.class);
		return resp;
	}



	/**
	 * 解析js支付通知报文
	 *TODO 目前，只是拿到订单没有直接信任，而以去查单 所以没有使用验签功能，所以忽略掉了很多字段。
	 * @param noticeResp
	 * @return
	 */
	public static MappJsPayResponse mappJsPayNotice(String noticeResp){
		MappJsPayResponse resp = XStreamUtil.fromXml(noticeResp, MappJsPayResponse.class);
		return resp;
	}
	
	
	/**
	 * 创建回复支付通知的报文
	 * @param success
	 * @param msg
	 * @return
	 */
	public static String createNoticeAnswer(boolean success,String msg){
		return String.format("<xml><return_code><![CDATA[%s]]></return_code><return_msg><![CDATA[%s]]></return_msg></xml>", success?"SUCCESS":"FAIL",msg);
	}


}
