package com.mini.framework.third.weixin.pay.client;

import java.util.Map;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.mini.framework.third.weixin.pay.model.UserMappPayRequest;
import com.mini.framework.util.string.XStreamUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;


/**
 * 公众号支付前数据准备的请求
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class MappPrePayRequest extends ConnMessageRequest implements MessageMd5Signable{

    @XStreamAlias("attach")
    private String attach;

    @XStreamAlias("body")
    private String body;

    @XStreamAlias("detail")
    private String detail;

    @XStreamAlias("notify_url")
    private String notifyUrl;

    @XStreamAlias("openid")
    private String openid;

    @XStreamAlias("out_trade_no")
    private String outTradeNo;

    @XStreamAlias("spbill_create_ip")
    private String spbillCreateIp;

    @XStreamAlias("total_fee")
    private Integer totalFee;

    @XStreamAlias("trade_type")
    private String tradeType = "JSAPI";
    
    /**
     * 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。订单失效时间是针对订单号而言的，由于在请求支付的时候有一个必传参数prepay_id只有两小时的有效期，所以在重入时间超过2小时的时候需要重新请求下单接口获取新的prepay_id。其他详见
     */
    @XStreamAlias("time_expire")
    private String expireDate;

	public String getAttach() {
		return attach;
	}

	public void setAttach(String attach) {
		this.attach = attach;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getSpbillCreateIp() {
		return spbillCreateIp;
	}

	public void setSpbillCreateIp(String spbillCreateIp) {
		this.spbillCreateIp = spbillCreateIp;
	}

	public Integer getTotalFee() {
		return totalFee;
	}

	public void setTotalFee(Integer totalFee) {
		this.totalFee = totalFee;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}
    
    public String getExpireDate() {
		return expireDate;
	}

	public void setExpireDate(String expireDate) {
		this.expireDate = expireDate;
	}

	public Map<String, String> toMap(){
    	return XStreamUtil.beanToMap(this);
    }
    
    public MappPrePayRequest() {
		super();
	}
    
    public MappPrePayRequest(UserMappPayRequest request) {
		this.setOutTradeNo(request.getOrderId());
		this.setTotalFee(request.getOrderAmount());
		this.setBody(request.getOrderName());
		this.setOpenid(request.getOpenid());
		this.setSpbillCreateIp(request.getSpbillCreateIp());
	}

	@Override
    public String toString() {

		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }

	@Override
	public String messageType() {
		return "公众号预支付请求";
	}
}
