package com.mini.framework.third.weixin.pay.client;

import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;


public interface PayApi {
	
    /**
     * https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_1
     * 微信公众号支付
     * @param body
     * @return
     */
	@POST("/pay/unifiedorder")
	Call<PublicPrePayResponse> publicPay(@Body RequestBody body);
	
	
	/**
	 * 接口链接：https://api.mch.weixin.qq.com/secapi/pay/refund
	 * @param body
	 * @return
	 */
	@POST("/secapi/pay/refund")
	Call<PublicRefundApplyResponse> refoundApply(@Body RequestBody body);
	
	
	
    @POST("/pay/unifiedorder")
    Call<MappPrePayResponse> mappPay(@Body RequestBody body);
    
    

    /**
     * 查询订单
     * https://pay.weixin.qq.com/wiki/doc/api/jsapi_sl.php?chapter=9_2
     * @param body
     * @return
     */
    @POST("/pay/orderquery")
    Call<QueryOrderResponse> orderQuery(@Body RequestBody body);

    /**
     * 用户退款请求.
     *
     * @param body 请求体
     * @return
     */
    @POST("/secapi/pay/refund")
    Call<MappRefundResponse> refund(@Body RequestBody body);

    /**
     * 企业付款给用户.
     *
     * @param body 请求体
     * @return
     */
    @POST("/mmpaymkttransfers/promotion/transfers")
    Call<MappTransferResponse> transfers(@Body RequestBody body);

    @POST("/mmpaymkttransfers/gettransferinfo")
    Call<MappSiteTransferInfoResponse> transferInfoQuery(@Body RequestBody body);
}
