package com.mini.framework.third.weixin.pay.client;

import java.util.Map;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

import com.mini.framework.util.string.XStreamUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;


/**
 * @Auther: yuyi
 * @Date: 2018/8/25 18:35
 * @Description: 同步返回参数
 */
@XStreamAlias("xml")
@Root(name = "xml", strict = false)
public class PublicRefundApplyResponse extends ConnMessageResponse{


    /**
     * transaction_id和outTradeNo只要一个
     * 站点程序提供的订单号
     */
    @Element(name = "out_trade_no", required = false)
    @XStreamAlias("out_trade_no")
    private String outTradeNo;
	
    /**
     * 商户退款单号	out_refund_no	是	String(64)	1217752501201407033233368018	商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。
     */
    @Element(name = "out_refund_no", required = false)
    @XStreamAlias("out_refund_no")
    private String outRefundNo;
	
	
	/**
	 * 微信退款单号	refund_id	是	String(32)	2007752501201407033233368018	微信退款单号
	 */
    @Element(name = "refund_id", required = false)
    @XStreamAlias("refund_id")
	private String weixinRefundNo;
	
	
    /**
     * 退款金额	refund_fee	是	Int	100	退款总金额,单位为分,可以做部分退款
     */
    @Element(name = "refund_fee", required = false)
    @XStreamAlias("refund_fee")
    private Integer refundFee;
	
	
    
    public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getOutRefundNo() {
		return outRefundNo;
	}

	public void setOutRefundNo(String outRefundNo) {
		this.outRefundNo = outRefundNo;
	}

	public String getWeixinRefundNo() {
		return weixinRefundNo;
	}

	public void setWeixinRefundNo(String weixinRefundNo) {
		this.weixinRefundNo = weixinRefundNo;
	}

	public Integer getRefundFee() {
		return refundFee;
	}

	public void setRefundFee(Integer refundFee) {
		this.refundFee = refundFee;
	}


	@Override
    public String toString() {

		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
    
    public Map<String, String> toMap(){
    	return XStreamUtil.beanToMap(this);
    }

	@Override
	public String messageType() {
		return "公众号退款响应";
	}
}
