package com.mini.framework.third.weixin.pay.model;

import com.mini.framework.third.weixin.pay.client.ConnMessageResponse;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang3.RandomStringUtils;
import org.simpleframework.xml.Element;

import java.util.Date;

/**
 * 企业支付给用户响应
 *
 * @author riefu233
 */
public class UserMappTransferResponse extends ConnMessageResponse {



    /** 商家提现支付订单号 **/
    @XStreamAlias("partner_trade_no")
    @Element(name = "partner_trade_no",required = false)
    private String siteOrderNo;

    /** 企业付款成功时间. **/
    @XStreamAlias("payment_time")
    @Element(name = "payment_time",required = false)
    private Date paymentTime;

    /** 微信支付订单号. **/
    @XStreamAlias("payment_no")
    @Element(name = "payment_no",required = false)
    private String  paymentNo;

    private String timeStamp;

    private String paySign;


    public String getSiteOrderNo() {
        return siteOrderNo;
    }

    public void setSiteOrderNo(String siteOrderNo) {
        this.siteOrderNo = siteOrderNo;
    }


    @Override
    public String showSign() {
        return this.showSign();
    }

    @Override
    public void fillSign(String sign) {
        this.setPaySign(sign);
    }

    @Override
    public String messageType() {
        return "企业付款响应";
    }

    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    public String getPaymentNo() {
        return paymentNo;
    }

    public void setPaymentNo(String paymentNo) {
        this.paymentNo = paymentNo;
    }

    public String getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getPaySign() {
        return paySign;
    }

    public void setPaySign(String paySign) {
        this.paySign = paySign;
    }
}
