package com.mini.framework.third.weixin.pay.model;

import java.util.Map;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import com.mini.framework.util.string.XStreamUtil;
import com.mini.framework.third.weixin.pay.client.MessageMd5Signable;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * @Auther: yuyi
 * @Date: 2018/8/25 12:37
 * @Description: 支付时的同步返回参数
 */
//@Data
public class UserPublicPayResponse implements MessageMd5Signable{

    /** 以下字段仅在微信h5支付返回. */
    private String appId;

    private String timeStamp;

    private String nonceStr = RandomStringUtils.randomNumeric(16);

    @XStreamAlias("package")
    private String packAge;

    /**
     * 直接使用md5
     */
    private String signType = "MD5";

    private String paySign;

    /** 以下字段在微信异步通知下返回. */
    private Double orderAmount;

    private String orderId;

    //第三方支付的流水号 支付发起方生成
    private String outTradeNo;

    /** 以下支付是h5支付返回*/
    private String mwebUrl;


	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getTimeStamp() {
		return timeStamp;
	}

	public void setTimeStamp(String timeStamp) {
		this.timeStamp = timeStamp;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getPackAge() {
		return packAge;
	}

	public void setPackAge(String packAge) {
		this.packAge = packAge;
	}

	public String getSignType() {
		return signType;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getPaySign() {
		return paySign;
	}

	public void setPaySign(String paySign) {
		this.paySign = paySign;
	}

	public Double getOrderAmount() {
		return orderAmount;
	}

	public void setOrderAmount(Double orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getMwebUrl() {
		return mwebUrl;
	}

	public void setMwebUrl(String mwebUrl) {
		this.mwebUrl = mwebUrl;
	}
    
    @Override
    public String toString() {

		return ToStringBuilder.reflectionToString(this,ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
	@Override
	public String messageType() {
		return "公众号支付响应";
	}
    
    public Map<String, String> toMap(){
    	return XStreamUtil.beanToMap(this);
    }

	@Override
	public String showSign() {
		return this.getPaySign();
	}

	@Override
	public void fillSign(String sign) {
		this.setPaySign(sign);
	}
    
}
