package com.mini.framework.third.weixin.pay.model;

import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.ssl.SSLContexts;
import sun.misc.BASE64Decoder;

import javax.net.ssl.SSLContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;

public class WeixinCompanyPayConfig {

    /**
     * 支付完成后的异步通知地址.
     */
    private String notifyUrl;

    /**
     * 支付完成后的同步返回地址.
     */
    private String returnUrl;

    /**
     * 公众号appId
     */
    private String appId;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 商户密钥
     * 密钥文件目前没有使用到。
     */
    private String mchKey;

    /**
     * 商户的证书文件
     */
    private String mchCert;


    /**
     * 证书内容
     */
    private SSLContext sslContext;


    public SSLContext initSSLContext() {
        AssertUtil.validateParams(mchCert != null, "商家支付号证书不能为空");
        AssertUtil.validateParams(mchId != null, "商家号不能为空");
        ByteArrayInputStream inputStream;
        try {
            byte[] bytes = new BASE64Decoder().decodeBuffer(mchCert);
            inputStream = new ByteArrayInputStream(bytes);
        } catch (IOException e) {
            throw new HandleIOException(e, "读取微信商户证书文件出错");
        }

        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            char[] partnerId2charArray = mchId.toCharArray();
            keystore.load(inputStream, partnerId2charArray);
            this.sslContext = SSLContexts.custom().loadKeyMaterial(keystore, partnerId2charArray).build();
            return this.sslContext;
        } catch (Exception e) {
            throw new BusyException("证书文件有问题，请核实！", e);
        } finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getMchKey() {
        return mchKey;
    }

    public void setMchKey(String mchKey) {
        this.mchKey = mchKey;
    }

    public String getMchCert() {
        return mchCert;
    }

    public void setMchCert(String mchCert) {
        this.mchCert = mchCert;
    }

    public SSLContext getSslContext() {
        return sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

}
